/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.FindInheritedFields;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class AddLogger
extends JavaIsoVisitor<ExecutionContext> {
    private final J.ClassDeclaration scope;
    private final String loggerType;
    private final String factoryType;
    private final String loggerName;
    private final JavaTemplate template;

    public AddLogger(J.ClassDeclaration scope, String loggerType, String factoryType, String loggerName, Function<JavaVisitor<?>, JavaTemplate> template) {
        this.scope = scope;
        this.loggerType = loggerType;
        this.factoryType = factoryType;
        this.loggerName = loggerName;
        this.template = template.apply((JavaVisitor<?>)this);
    }

    public static TreeVisitor<J, ExecutionContext> addLogger(J.ClassDeclaration scope, LoggingFramework loggingFramework, String loggerName) {
        switch (loggingFramework) {
            case Log4J1: {
                return AddLogger.addLog4j1Logger(scope, loggerName);
            }
            case Log4J2: {
                return AddLogger.addLog4j2Logger(scope, loggerName);
            }
            case JUL: {
                return AddLogger.addJulLogger(scope, loggerName);
            }
        }
        return AddLogger.addSlf4jLogger(scope, loggerName);
    }

    public static AddLogger addSlf4jLogger(J.ClassDeclaration scope, String loggerName) {
        return new AddLogger(scope, "org.slf4j.Logger", "org.slf4j.LoggerFactory", loggerName, visitor -> JavaTemplate.builder((String)"private static final Logger #{} = LoggerFactory.getLogger(#{}.class);").contextSensitive().imports(new String[]{"org.slf4j.Logger", "org.slf4j.LoggerFactory"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"})).build());
    }

    public static AddLogger addJulLogger(J.ClassDeclaration scope, String loggerName) {
        return new AddLogger(scope, "java.util.logging.Logger", "java.util.logging.LogManager", loggerName, visitor -> JavaTemplate.builder((String)"private static final Logger #{} = LogManager.getLogger(\"#{}\");").contextSensitive().imports(new String[]{"java.util.logging.Logger", "java.util.logging.LogManager"}).build());
    }

    public static AddLogger addLog4j1Logger(J.ClassDeclaration scope, String loggerName) {
        return new AddLogger(scope, "org.apache.log4j.Logger", "org.apache.log4j.LogManager", loggerName, visitor -> JavaTemplate.builder((String)"private static final Logger #{} = LogManager.getLogger(#{}.class);").contextSensitive().imports(new String[]{"org.apache.log4j.Logger", "org.apache.log4j.LogManager"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"log4j"})).build());
    }

    public static AddLogger addLog4j2Logger(J.ClassDeclaration scope, String loggerName) {
        return new AddLogger(scope, "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", loggerName, visitor -> JavaTemplate.builder((String)"private static final Logger #{} = LogManager.getLogger(#{}.class);").contextSensitive().imports(new String[]{"org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"log4j-api"})).build());
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
        if (cd == this.scope) {
            if (!FindInheritedFields.find((J)cd, (String)this.loggerType).isEmpty() || !FindFieldsOfType.find((J)cd, (String)this.loggerType).isEmpty()) {
                return cd;
            }
            Comparator firstAfterEnumValueSet = (unused, o2) -> o2 instanceof J.EnumValueSet ? 1 : -1;
            cd = (J.ClassDeclaration)this.template.apply(this.updateCursor((Tree)cd), cd.getBody().getCoordinates().addStatement(firstAfterEnumValueSet), new Object[]{this.loggerName, cd.getSimpleName()});
            J.ClassDeclaration formatted = (J.ClassDeclaration)new AutoFormatVisitor().visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParent());
            cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), (i, stat) -> {
                if (i == 1) {
                    return (Statement)stat.withPrefix(((Statement)formatted.getBody().getStatements().get((int)i)).getPrefix());
                }
                return stat;
            })));
            this.maybeAddImport(this.loggerType);
            this.maybeAddImport(this.factoryType);
        }
        return cd;
    }
}

