/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.logging.LoggingFramework;

public class ChangeLombokLogAnnotation
extends Recipe {
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J1", "Log4J2", "JUL", "COMMONS"}, required=false)
    @Nullable
    private String loggingFramework;

    public String getDisplayName() {
        return "Replace any Lombok log annotations with target logging framework annotation";
    }

    public String getDescription() {
        return "Replace Lombok annotations such as `@CommonsLog` and `@Log4j` with the target logging framework annotation, or `@Sl4fj` if not provided.";
    }

    public List<Recipe> getRecipeList() {
        String targetLogAnnotationType = ChangeLombokLogAnnotation.getTargetAnnotationType(this.loggingFramework);
        return Stream.of("lombok.extern.java.Log", "lombok.extern.apachecommons.CommonsLog", "lombok.extern.flogger.Flogger", "lombok.extern.jbosslog.JBossLog", "lombok.extern.log4j.Log4j", "lombok.extern.log4j.Log4j2", "lombok.extern.slf4j.Slf4j", "lombok.extern.slf4j.XSlf4j", "lombok.CustomLog").filter(annotationType -> !annotationType.equals(targetLogAnnotationType)).map(annotationType -> new ChangeType(annotationType, targetLogAnnotationType, Boolean.valueOf(true))).collect(Collectors.toList());
    }

    private static String getTargetAnnotationType(@Nullable String loggingFramework) {
        if (loggingFramework != null) {
            switch (LoggingFramework.fromOption(loggingFramework)) {
                case Log4J1: {
                    return "lombok.extern.log4j.Log4j";
                }
                case Log4J2: {
                    return "lombok.extern.log4j.Log4j2";
                }
                case JUL: {
                    return "lombok.extern.java.Log";
                }
                case COMMONS: {
                    return "lombok.extern.apachecommons.CommonsLog";
                }
            }
        }
        return "lombok.extern.slf4j.Slf4j";
    }

    @ConstructorProperties(value={"loggingFramework"})
    public ChangeLombokLogAnnotation(@Nullable String loggingFramework) {
        this.loggingFramework = loggingFramework;
    }
}

