/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.logging.PrintStackTraceToLogError;
import org.openrewrite.java.logging.SystemErrToLogging;
import org.openrewrite.java.logging.SystemOutToLogging;

public final class SystemPrintToLogging
extends Recipe {
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    @Nullable
    private final Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false, example="log")
    @Nullable
    private final String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J1", "Log4J2", "JUL", "COMMONS"}, required=false)
    @Nullable
    private final String loggingFramework;
    @Option(displayName="Level", description="The logging level to turn `System.out` print statements into.", valid={"trace", "debug", "info"}, required=false)
    @Nullable
    private final String level;
    private final AtomicReference<Object> recipeList = new AtomicReference();

    public String getDisplayName() {
        return "Use logger instead of system print statements";
    }

    public String getDescription() {
        return "Replace `System.out` and `System.err` print statements with a logger.";
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework", "level"})
    public SystemPrintToLogging(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework, @Nullable String level) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
        this.level = level;
    }

    @Nullable
    public Boolean getAddLogger() {
        return this.addLogger;
    }

    @Nullable
    public String getLoggerName() {
        return this.loggerName;
    }

    @Nullable
    public String getLoggingFramework() {
        return this.loggingFramework;
    }

    @Nullable
    public String getLevel() {
        return this.level;
    }

    @NonNull
    public String toString() {
        return "SystemPrintToLogging(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ", level=" + this.getLevel() + ", recipeList=" + this.getRecipeList() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemPrintToLogging)) {
            return false;
        }
        SystemPrintToLogging other = (SystemPrintToLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        if (this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        List<Recipe> this$recipeList = this.getRecipeList();
        List<Recipe> other$recipeList = other.getRecipeList();
        return !(this$recipeList == null ? other$recipeList != null : !((Object)this$recipeList).equals(other$recipeList));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SystemPrintToLogging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        List<Recipe> $recipeList = this.getRecipeList();
        result = result * 59 + ($recipeList == null ? 43 : ((Object)$recipeList).hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Recipe> getRecipeList() {
        Object $value = this.recipeList.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.recipeList;
            synchronized (atomicReference) {
                $value = this.recipeList.get();
                if ($value == null) {
                    List<Recipe> actualValue = Arrays.asList(new Recipe[]{new SystemErrToLogging(this.addLogger, this.loggerName, this.loggingFramework), new SystemOutToLogging(this.addLogger, this.loggerName, this.loggingFramework, this.level), new PrintStackTraceToLogError(this.addLogger, this.loggerName, this.loggingFramework)});
                    $value = actualValue == null ? this.recipeList : actualValue;
                    this.recipeList.set($value);
                }
            }
        }
        return (List)($value == this.recipeList ? null : $value);
    }
}

