/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class ParameterizedLogging
extends Recipe {
    @Option(displayName="Method pattern", description="A method used to find matching statements to parameterize.", example="org.slf4j.Logger info(..)")
    private final String methodPattern;
    @Option(displayName="Remove `Object#toString()` invocations from logging parameters", description="Optionally remove `toString(`) method invocations from Object parameters.", required=false)
    private final @Nullable Boolean removeToString;

    public String getDisplayName() {
        return "Parameterize logging statements";
    }

    public String getDescription() {
        return "Transform logging statements using concatenation for messages and variables into a parameterized format. For example, `logger.info(\"hi \" + userName)` becomes `logger.info(\"hi {}\", userName)`. This can significantly boost performance for messages that otherwise would be assembled with String concatenation. Particularly impactful when the log level is not enabled, as no work is done to assemble the message.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-S2629", "RSPEC-S3457"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(this.methodPattern, true), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher matcher;
            private final RemoveToStringVisitor removeToStringVisitor;
            {
                this.matcher = new MethodMatcher(ParameterizedLogging.this.methodPattern, true);
                this.removeToStringVisitor = new RemoveToStringVisitor();
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.matcher.matches((MethodCall)m) && !m.getArguments().isEmpty() && !(m.getArguments().get(0) instanceof J.Empty) && m.getArguments().size() <= 2) {
                    int logMsgIndex = this.isMarker((Expression)m.getArguments().get(0)) ? 1 : 0;
                    Expression logMsg = (Expression)m.getArguments().get(logMsgIndex);
                    if (logMsg instanceof J.Binary) {
                        StringBuilder messageBuilder = new StringBuilder();
                        ArrayList newArgList = new ArrayList();
                        ListUtils.map((List)m.getArguments(), (index, message) -> {
                            if (index > 0) {
                                messageBuilder.append(", ");
                            }
                            if (index == logMsgIndex && message instanceof J.Binary) {
                                messageBuilder.append("\"");
                                MessageAndArguments literalAndArgs = ParameterizedLogging.concatenationToLiteral(message, new MessageAndArguments("", new ArrayList()));
                                messageBuilder.append(literalAndArgs.message);
                                messageBuilder.append("\"");
                                literalAndArgs.arguments.forEach(arg -> messageBuilder.append(", #{any()}"));
                                newArgList.addAll(literalAndArgs.arguments);
                            } else {
                                messageBuilder.append("#{any()}");
                                newArgList.add(message);
                            }
                            return message;
                        });
                        m = (J.MethodInvocation)JavaTemplate.builder((String)ParameterizedLogging.escapeDollarSign(messageBuilder.toString())).build().apply(new Cursor(this.getCursor().getParent(), (Object)m), m.getCoordinates().replaceArguments(), newArgList.toArray());
                    } else {
                        if (logMsg instanceof J.Identifier && TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)logMsg.getType())) {
                            return m;
                        }
                        if (!TypeUtils.isString((JavaType)logMsg.getType()) && logMsg.getType() instanceof JavaType.Class && !TypeUtils.isAssignableTo((String)"java.util.function.Supplier", (JavaType)logMsg.getType())) {
                            StringBuilder messageBuilder = new StringBuilder();
                            if (logMsgIndex == 1) {
                                messageBuilder.append("#{any()}, ");
                            }
                            messageBuilder.append("\"{}\"");
                            for (int i = logMsgIndex; i < m.getArguments().size(); ++i) {
                                messageBuilder.append(", #{any()}");
                            }
                            m = (J.MethodInvocation)JavaTemplate.builder((String)ParameterizedLogging.escapeDollarSign(messageBuilder.toString())).contextSensitive().build().apply(new Cursor(this.getCursor().getParent(), (Object)m), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                        }
                    }
                    if (Boolean.TRUE.equals(ParameterizedLogging.this.removeToString)) {
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> (Expression)this.removeToStringVisitor.visitNonNull((Tree)arg, ctx, this.getCursor())));
                    }
                }
                if (m != method && m.print(this.getCursor().getParentTreeCursor()).equals(method.print(this.getCursor().getParentTreeCursor()))) {
                    return method;
                }
                return m;
            }

            private boolean isMarker(Expression expression) {
                JavaType expressionType = expression.getType();
                return TypeUtils.isAssignableTo((String)"org.slf4j.Marker", (JavaType)expressionType) || TypeUtils.isAssignableTo((String)"org.apache.logging.log4j.Marker", (JavaType)expressionType);
            }
        });
    }

    private static MessageAndArguments concatenationToLiteral(Expression message, MessageAndArguments result) {
        if (!(message instanceof J.Binary)) {
            result.arguments.add(message);
            return result;
        }
        J.Binary concat = (J.Binary)message;
        if (concat.getLeft() instanceof J.Binary && ((J.Binary)concat.getLeft()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getLeft(), result);
        } else if (concat.getLeft() instanceof J.Literal) {
            J.Literal left = (J.Literal)concat.getLeft();
            result.message = ParameterizedLogging.getLiteralValue(left) + result.message;
            result.previousMessageWasStringLiteral = left.getType() == JavaType.Primitive.String;
        } else {
            result.message = "{}" + result.message;
            result.arguments.add(concat.getLeft());
            result.previousMessageWasStringLiteral = false;
        }
        if (concat.getRight() instanceof J.Binary && ((J.Binary)concat.getRight()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getRight(), result);
        } else if (concat.getRight() instanceof J.Literal) {
            boolean rightIsStringLiteral;
            J.Literal right = (J.Literal)concat.getRight();
            boolean bl = rightIsStringLiteral = right.getType() == JavaType.Primitive.String;
            if (result.previousMessageWasStringLiteral && rightIsStringLiteral) {
                result.message = result.message + ("\" +" + right.getPrefix().getWhitespace() + "\"" + ParameterizedLogging.getLiteralValue(right));
            } else {
                result.message = result.message + ParameterizedLogging.getLiteralValue(right);
            }
            result.previousMessageWasStringLiteral = rightIsStringLiteral;
        } else {
            if (result.message.endsWith("#")) {
                result.message = result.message + "\\";
            }
            result.message = result.message + "{}";
            result.arguments.add(concat.getRight());
            result.previousMessageWasStringLiteral = false;
        }
        return result;
    }

    private static @Nullable Object getLiteralValue(J.Literal literal) {
        if (literal.getValueSource() == null || literal.getType() != JavaType.Primitive.String) {
            return literal.getValue();
        }
        return literal.getValueSource().substring(1, literal.getValueSource().length() - 1).replace("\\", "\\\\");
    }

    private static String escapeDollarSign(@NonNull String value) {
        return value.replaceAll("\\$", "\\\\\\$");
    }

    @ConstructorProperties(value={"methodPattern", "removeToString"})
    @Generated
    public ParameterizedLogging(String methodPattern, @Nullable Boolean removeToString) {
        this.methodPattern = methodPattern;
        this.removeToString = removeToString;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable Boolean getRemoveToString() {
        return this.removeToString;
    }

    @org.openrewrite.internal.lang.NonNull
    @Generated
    public String toString() {
        return "ParameterizedLogging(methodPattern=" + this.getMethodPattern() + ", removeToString=" + this.getRemoveToString() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterizedLogging)) {
            return false;
        }
        ParameterizedLogging other = (ParameterizedLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeToString = this.getRemoveToString();
        Boolean other$removeToString = other.getRemoveToString();
        if (this$removeToString == null ? other$removeToString != null : !((Object)this$removeToString).equals(other$removeToString)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ParameterizedLogging;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeToString = this.getRemoveToString();
        result = result * 59 + ($removeToString == null ? 43 : ((Object)$removeToString).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private static final class MessageAndArguments {
        private final List<Expression> arguments;
        private String message;
        boolean previousMessageWasStringLiteral;

        private MessageAndArguments(String message, List<Expression> arguments) {
            this.message = message;
            this.arguments = arguments;
        }
    }

    private static class RemoveToStringVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaTemplate t = JavaTemplate.builder((String)"#{any(java.lang.String)}").build();
        private final MethodMatcher TO_STRING = new MethodMatcher("*..* toString()");

        private RemoveToStringVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (((Boolean)this.getCursor().getNearestMessage("DO_NOT_REMOVE", (Object)Boolean.FALSE)).booleanValue()) {
                return method;
            }
            if (this.TO_STRING.matches(method.getSelect())) {
                this.getCursor().putMessage("DO_NOT_REMOVE", (Object)Boolean.TRUE);
            } else if (this.TO_STRING.matches((MethodCall)method)) {
                return this.t.apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }
    }
}

