/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JulGetLoggerToLoggerFactoryRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL Logger creation with SLF4J LoggerFactory";
    }

    public String getDescription() {
        return "Replace calls to `Logger.getLogger` with `LoggerFactory.getLogger`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new GetLoggerClassNameToLoggerFactoryRecipe(), new GetLoggerClassCanonicalNameToLoggerFactoryRecipe()});
    }

    @NullMarked
    public static class GetLoggerClassNameToLoggerFactoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.getLogger(Some.class.getName())` with SLF4J's `LoggerFactory.getLogger(Some.class)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.getLogger(Some.class.getName())` with `org.slf4j.LoggerFactory.getLogger(Some.class)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.logging.Logger.getLogger(#{clazz:any(java.lang.Class<?>)}.getName())").bindType("java.util.logging.Logger").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.slf4j.LoggerFactory.getLogger(#{clazz:any(java.lang.Class<?>)})").bindType("org.slf4j.Logger").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.lang.Class getName(..)", true), new UsesMethod("java.util.logging.Logger getLogger(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class GetLoggerClassCanonicalNameToLoggerFactoryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.getLogger(Some.class.getCanonicalName())` with SLF4J's `LoggerFactory.getLogger(Some.class)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.getLogger(Some.class.getCanonicalName())` with `org.slf4j.LoggerFactory.getLogger(Some.class)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.logging.Logger.getLogger(#{clazz:any(java.lang.Class<?>)}.getCanonicalName())").bindType("java.util.logging.Logger").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.slf4j.LoggerFactory.getLogger(#{clazz:any(java.lang.Class<?>)})").bindType("org.slf4j.Logger").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.lang.Class getCanonicalName(..)", true), new UsesMethod("java.util.logging.Logger getLogger(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

