/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public final class ConvertJulExiting
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.util.logging.Logger exiting(String, String, ..)", false);

    public String getDisplayName() {
        return "Rewrites JUL's Logger#exiting method to Log4j API";
    }

    public String getDescription() {
        return "Replaces JUL's Logger#exiting method calls to Log4j API Logger#traceEntry calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)m) && m.getMethodType() != null) {
                    List originalArgs = m.getPadding().getArguments().getPadding().getElements();
                    List originalTypes = m.getMethodType().getParameterTypes();
                    int originalArgCount = originalArgs.size();
                    if (3 < originalArgCount) {
                        return m;
                    }
                    ArrayList<Expression> modifiedArgs = new ArrayList<Expression>();
                    ArrayList<JavaType> modifiedTypes = new ArrayList<JavaType>();
                    if (originalArgCount > 2) {
                        modifiedArgs.add((Expression)((Expression)((JRightPadded)originalArgs.get(2)).getElement()).withPrefix(Space.EMPTY));
                        modifiedTypes.add((JavaType)originalTypes.get(2));
                    }
                    JavaType.Method mt = m.getMethodType().withParameterTypes(modifiedTypes).withDeclaringType(m.getMethodType().getDeclaringType().withFullyQualifiedName("org.apache.logging.log4j.Logger"));
                    return m.withMethodType(mt).withName(m.getName().withSimpleName("traceExit")).withArguments(modifiedArgs);
                }
                return m;
            }
        });
    }

    @Generated
    public ConvertJulExiting() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "ConvertJulExiting()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertJulExiting)) {
            return false;
        }
        ConvertJulExiting other = (ConvertJulExiting)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConvertJulExiting;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

