/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.micrometer.dropwizard;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.micrometer.table.DropwizardMetricsInUse;

public class FindDropwizardMetrics
extends Recipe {
    final transient DropwizardMetricsInUse metrics = new DropwizardMetricsInUse(this);

    public String getDisplayName() {
        return "Find Dropwizard metrics";
    }

    public String getDescription() {
        return "Find uses of Dropwizard metrics that could be converted to a more modern metrics instrumentation library.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher counter = new MethodMatcher("com.codahale.metrics.MetricRegistry counter(..)");
        final MethodMatcher gauge = new MethodMatcher("com.codahale.metrics.MetricRegistry gauge(..)");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (counter.matches((MethodCall)method) || gauge.matches((MethodCall)method)) {
                    String metricType = counter.matches((MethodCall)method) ? "Counter" : "Gauge";
                    FindDropwizardMetrics.this.metrics.insertRow(ctx, new DropwizardMetricsInUse.Row(((J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).getSourcePath().toString(), metricType, method.printTrimmed(this.getCursor())));
                    return (J.MethodInvocation)SearchResult.found((Tree)method, (String)metricType);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

