/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class AddJaxbRuntime
extends Recipe {
    private static final String JAXB_API_GROUP = "jakarta.xml.bind";
    private static final String JAXB_API_ARTIFACT = "jakarta.xml.bind-api";
    private static final String SUN_JAXB_RUNTIME_GROUP = "com.sun.xml.bind";
    private static final String SUN_JAXB_RUNTIME_ARTIFACT = "jaxb-impl";
    private static final String GLASSFISH_JAXB_RUNTIME_GROUP = "org.glassfish.jaxb";
    private static final String GLASSFISH_JAXB_RUNTIME_ARTIFACT = "jaxb-runtime";
    @Option(displayName="JAXB run-time", description="Which implementation of the JAXB run-time that will be added to maven projects that have transitive dependencies on the JAXB API", valid={"glassfish", "sun"}, example="glassfish")
    private final String runtime;

    public String getDisplayName() {
        return "Add JAXB run-time dependency to a Maven project";
    }

    public String getDescription() {
        return "This recipe will add a JAXB run-time dependency to any maven project that has a transitive dependency on JAXB.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        this.doNext((Recipe)new RemoveDependency(SUN_JAXB_RUNTIME_GROUP, "jaxb-core", null));
        ReplaceRuntimeVisitor replaceRuntime = "sun".equals(this.runtime) ? new ReplaceRuntimeVisitor(GLASSFISH_JAXB_RUNTIME_GROUP, GLASSFISH_JAXB_RUNTIME_ARTIFACT, SUN_JAXB_RUNTIME_GROUP, SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x") : new ReplaceRuntimeVisitor(SUN_JAXB_RUNTIME_GROUP, SUN_JAXB_RUNTIME_ARTIFACT, GLASSFISH_JAXB_RUNTIME_GROUP, GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x");
        HashMap gavToPom = new HashMap();
        List sources = ListUtils.map(before, s -> {
            if (s instanceof Maven) {
                Maven mavenSource = (Maven)replaceRuntime.visit((Tree)s, ctx);
                gavToPom.put(mavenSource.getCoordinates(), mavenSource.getModel());
                return mavenSource;
            }
            return s;
        });
        sources = ListUtils.map((List)sources, s -> {
            if (s instanceof Maven) {
                Scope runtimeScope;
                Maven mavenSource = (Maven)s;
                Scope apiScope = this.getTransitiveDependencyScope(mavenSource.getModel(), JAXB_API_GROUP, JAXB_API_ARTIFACT, gavToPom);
                Scope scope = runtimeScope = "sun".equals(this.runtime) ? this.getTransitiveDependencyScope(mavenSource.getModel(), SUN_JAXB_RUNTIME_GROUP, SUN_JAXB_RUNTIME_ARTIFACT, gavToPom) : this.getTransitiveDependencyScope(mavenSource.getModel(), GLASSFISH_JAXB_RUNTIME_GROUP, GLASSFISH_JAXB_RUNTIME_ARTIFACT, gavToPom);
                if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                    String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                    AddDependencyVisitor addDependency = "sun".equals(this.runtime) ? new AddDependencyVisitor(SUN_JAXB_RUNTIME_GROUP, SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null) : new AddDependencyVisitor(GLASSFISH_JAXB_RUNTIME_GROUP, GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null);
                    return (SourceFile)addDependency.visit((Tree)mavenSource, (Object)ctx);
                }
                return mavenSource;
            }
            return s;
        });
        return sources;
    }

    @Nullable
    private Scope getTransitiveDependencyScope(Pom pom, String groupId, String artifactId, Map<String, Pom> gavToPoms) {
        Pom localPom = gavToPoms.get(pom.getCoordinates());
        if (localPom != null) {
            pom = localPom;
        }
        Scope scope = null;
        for (Pom.Dependency dependency : pom.getDependencies()) {
            if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId()) || !Scope.Compile.equals((Object)(scope = Scope.maxPrecedence((Scope)scope, (Scope)dependency.getScope())))) continue;
            return scope;
        }
        if (pom.getParent() != null && Scope.Compile.equals((Object)(scope = Scope.maxPrecedence(scope, (Scope)this.getTransitiveDependencyScope(pom.getParent(), groupId, artifactId, gavToPoms))))) {
            return scope;
        }
        for (Pom.Dependency dependency : pom.getDependencies()) {
            if (!Scope.Compile.equals((Object)(scope = Scope.maxPrecedence((Scope)scope, (Scope)this.getTransitiveDependencyScope(dependency.getModel(), groupId, artifactId, gavToPoms))))) continue;
            return scope;
        }
        return scope;
    }

    @ConstructorProperties(value={"runtime"})
    public AddJaxbRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    @NonNull
    public String toString() {
        return "AddJaxbRuntime(runtime=" + this.getRuntime() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxbRuntime)) {
            return false;
        }
        AddJaxbRuntime other = (AddJaxbRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$runtime = this.getRuntime();
        String other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxbRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        return result;
    }

    private static final class ReplaceRuntimeVisitor
    extends MavenVisitor {
        private final String oldGroupId;
        private final String oldArtifactId;
        private final String newGroupId;
        private final String newArtifactId;
        private final String newVersion;

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isDependencyTag(this.oldGroupId, this.oldArtifactId)) {
                Optional scopeTag = tag.getChild("scope");
                String scope = scopeTag.isPresent() && ((Xml.Tag)scopeTag.get()).getValue().isPresent() ? (String)((Xml.Tag)scopeTag.get()).getValue().get() : null;
                this.doAfterVisit((Recipe)new RemoveDependency(this.oldGroupId, this.oldArtifactId, scope));
                this.doAfterVisit((TreeVisitor)new AddDependencyVisitor(this.newGroupId, this.newArtifactId, "2.3.x", null, scope, null, null, null, null, null));
            }
            return tag;
        }

        @ConstructorProperties(value={"oldGroupId", "oldArtifactId", "newGroupId", "newArtifactId", "newVersion"})
        public ReplaceRuntimeVisitor(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, String newVersion) {
            this.oldGroupId = oldGroupId;
            this.oldArtifactId = oldArtifactId;
            this.newGroupId = newGroupId;
            this.newArtifactId = newArtifactId;
            this.newVersion = newVersion;
        }

        public String getOldGroupId() {
            return this.oldGroupId;
        }

        public String getOldArtifactId() {
            return this.oldArtifactId;
        }

        public String getNewGroupId() {
            return this.newGroupId;
        }

        public String getNewArtifactId() {
            return this.newArtifactId;
        }

        public String getNewVersion() {
            return this.newVersion;
        }

        @NonNull
        public String toString() {
            return "AddJaxbRuntime.ReplaceRuntimeVisitor(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceRuntimeVisitor)) {
                return false;
            }
            ReplaceRuntimeVisitor other = (ReplaceRuntimeVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$oldGroupId = this.getOldGroupId();
            String other$oldGroupId = other.getOldGroupId();
            if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
                return false;
            }
            String this$oldArtifactId = this.getOldArtifactId();
            String other$oldArtifactId = other.getOldArtifactId();
            if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
                return false;
            }
            String this$newGroupId = this.getNewGroupId();
            String other$newGroupId = other.getNewGroupId();
            if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
                return false;
            }
            String this$newArtifactId = this.getNewArtifactId();
            String other$newArtifactId = other.getNewArtifactId();
            if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
                return false;
            }
            String this$newVersion = this.getNewVersion();
            String other$newVersion = other.getNewVersion();
            return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ReplaceRuntimeVisitor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $oldGroupId = this.getOldGroupId();
            result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
            String $oldArtifactId = this.getOldArtifactId();
            result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
            String $newGroupId = this.getNewGroupId();
            result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
            String $newArtifactId = this.getNewArtifactId();
            result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
            String $newVersion = this.getNewVersion();
            result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
            return result;
        }
    }
}

