/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class MigrateLoggerLogrbToUseResourceBundle
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.util.logging.Logger logrb(java.util.logging.Level, String, String, String, String, ..)");

    public String getDisplayName() {
        return "Use `Logger#logrb(.., ResourceBundle bundleName, ..)`";
    }

    public String getDescription() {
        return "`java.util.logging.Logger#logrb(.., String bundleName, ..)` has been deprecated.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateLoggerLogrbToUseResourceBundleVisitor();
    }

    private static class MigrateLoggerLogrbToUseResourceBundleVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateLoggerLogrbToUseResourceBundleVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (MATCHER.matches(m)) {
                m = (J.MethodInvocation)m.withTemplate(JavaTemplate.builder(() -> ((MigrateLoggerLogrbToUseResourceBundleVisitor)this).getCursor(), (String)("#{any(java.util.logging.Level)}, #{any(String)}, #{any(String)}, ResourceBundle.getBundle(#{any(String)}), #{any(String)}" + (m.getArguments().size() == 6 ? ", #{any()}" : ""))).imports(new String[]{"java.util.ResourceBundle"}).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                this.maybeAddImport("java.util.ResourceBundle");
            }
            return super.visitMethodInvocation(m, (Object)ctx);
        }
    }
}

