/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateLogRecordSetMillisToSetInstant
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.util.logging.LogRecord setMillis(long)");

    public String getDisplayName() {
        return "Use `LogRecord#setInstant(Instant)`";
    }

    public String getDescription() {
        return "`LogRecord#setMillis(long)` has been deprecated.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateLogRecordSetMillisToSetInstantVisitor();
    }

    private static class MigrateLogRecordSetMillisToSetInstantVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateLogRecordSetMillisToSetInstantVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (MATCHER.matches(m)) {
                m = (J.MethodInvocation)m.withName(m.getName().withName("setInstant")).withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((MigrateLogRecordSetMillisToSetInstantVisitor)this).getCursor(), (String)"Instant.ofEpochMilli(#{any(long)})").imports(new String[]{"java.time.Instant"}).build(), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                this.maybeAddImport("java.time.Instant");
            }
            return super.visitMethodInvocation(m, (Object)ctx);
        }
    }
}

