/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaImmutableSetOf
extends Recipe {
    private final MethodMatcher IMMUTABLE_SET_MATCHER = new MethodMatcher("com.google.common.collect.ImmutableSet of(..)");

    public String getDisplayName() {
        return "Use `Set.of(..)` in Java 9 or higher";
    }

    public String getDescription() {
        return "Replaces `ImmutableSet.of(..)` if the returned type is immediately down-cast.\n  Java 9 introduced `List#of(..)`, `Map#of(..)`, `Set#of(..)` which is similar to `ImmutableList#of(..)`, `ImmutableMap#of(..)`, `ImmutableSet#of(..)`, but has a subtle difference.\n  As per the Java 9 documentation, [`Set.of` provides an unspecified iteration order on the set of elements and is subject to change](https://docs.oracle.com/javase/9/docs/api/java/util/Set.html), whereas [Guava `ImmutableSet` preserves the order from construction time](https://github.com/google/guava/wiki/ImmutableCollectionsExplained#how).\n  This is worth pointing out in case your usage calls for iteration order being important.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4738");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesType("com.google.common.collect.ImmutableSet")});
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NoGuavaImmutableSetOf.this.IMMUTABLE_SET_MATCHER.matches(method) && this.isParentTypeDownCast()) {
                    this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                    this.maybeAddImport("java.util.Set");
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)"java.util.Set"));
                    if (fq != null) {
                        String template = method.getArguments().stream().map(arg -> {
                            if (arg.getType() instanceof JavaType.Primitive) {
                                return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)("java.lang." + arg.getType())));
                            }
                            return TypeUtils.asFullyQualified((JavaType)arg.getType());
                        }).filter(Objects::nonNull).map(type -> "#{any(" + type.getFullyQualifiedName() + ")}").collect(Collectors.joining(",", fq.getClassName() + ".of(", ")"));
                        return method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)template).imports(new String[]{"java.util.Set"}).build(), method.getCoordinates().replace(), method.getArguments().get(0) instanceof J.Empty ? new Object[]{} : method.getArguments().toArray());
                    }
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }

            private boolean isParentTypeDownCast() {
                J parent = (J)this.getCursor().dropParentUntil(is -> is instanceof J).getValue();
                boolean isParentTypeDownCast = false;
                if (parent instanceof J.VariableDeclarations.NamedVariable) {
                    isParentTypeDownCast = this.isParentTypeMatched(((J.VariableDeclarations.NamedVariable)parent).getType());
                } else if (parent instanceof J.Assignment) {
                    J.Assignment a = (J.Assignment)parent;
                    if (a.getVariable() instanceof J.Identifier && ((J.Identifier)a.getVariable()).getFieldType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(((J.Identifier)a.getVariable()).getFieldType().getType());
                    } else if (a.getVariable() instanceof J.FieldAccess) {
                        isParentTypeDownCast = this.isParentTypeMatched(a.getVariable().getType());
                    }
                } else if (parent instanceof J.Return) {
                    TypeTree returnType;
                    J j = (J)this.getCursor().dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.CompilationUnit).getValue();
                    if (j instanceof J.MethodDeclaration && (returnType = ((J.MethodDeclaration)j).getReturnTypeExpression()) != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(returnType.getType());
                    }
                } else if (parent instanceof J.MethodInvocation) {
                    J.MethodInvocation m = (J.MethodInvocation)parent;
                    int index = 0;
                    for (Expression argument : m.getArguments()) {
                        if (NoGuavaImmutableSetOf.this.IMMUTABLE_SET_MATCHER.matches(argument)) break;
                        ++index;
                    }
                    if (m.getMethodType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched((JavaType)m.getMethodType().getParameterTypes().get(index));
                    }
                } else if (parent instanceof J.NewClass) {
                    J.NewClass c = (J.NewClass)parent;
                    int index = 0;
                    if (c.getConstructorType() != null && c.getArguments() != null) {
                        for (Expression argument : c.getArguments()) {
                            if (NoGuavaImmutableSetOf.this.IMMUTABLE_SET_MATCHER.matches(argument)) break;
                            ++index;
                        }
                        if (c.getConstructorType() != null) {
                            isParentTypeDownCast = this.isParentTypeMatched((JavaType)c.getConstructorType().getParameterTypes().get(index));
                        }
                    }
                }
                return isParentTypeDownCast;
            }

            private boolean isParentTypeMatched(@Nullable JavaType type) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                return TypeUtils.isOfClassType((JavaType)fq, (String)"java.util.Set");
            }
        };
    }
}

