/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.migrate.MavenUtils;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.RemoveDependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;

public final class AddJaxwsRuntime
extends Recipe {
    private static final String JAKARTA_JAXWS_API_GROUP = "jakarta.xml.ws";
    private static final String JAKARTA_JAXWS_API_ARTIFACT = "jakarta.xml.ws-api";
    private static final String SUN_JAXWS_RUNTIME_GROUP = "com.sun.xml.ws";
    private static final String SUN_JAXWS_RUNTIME_ARTIFACT = "jaxws-rt";

    public String getDisplayName() {
        return "Add JAX-WS run-time dependency to a Maven project";
    }

    public String getDescription() {
        return "This recipe will add a JAX-WS run-time dependency to any maven project that has a transitive dependency on JAX-WS APIs.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        this.doNext((Recipe)new RemoveDependency(SUN_JAXWS_RUNTIME_GROUP, "jaxws-ri", null));
        Map gavToModel = before.stream().filter(MavenUtils::isMavenSource).map(MavenUtils::getMavenModel).collect(Collectors.toMap(mavenModel -> new GroupArtifactVersion(mavenModel.getPom().getGroupId(), mavenModel.getPom().getArtifactId(), mavenModel.getPom().getVersion()), Function.identity()));
        return ListUtils.map(before, s -> {
            if (MavenUtils.isMavenSource(s)) {
                MavenResolutionResult mavenModel = MavenUtils.getMavenModel(s);
                Scope apiScope = AddJaxwsRuntime.getTransitiveDependencyScope(mavenModel, JAKARTA_JAXWS_API_GROUP, JAKARTA_JAXWS_API_ARTIFACT, gavToModel);
                Scope runtimeScope = AddJaxwsRuntime.getTransitiveDependencyScope(mavenModel, SUN_JAXWS_RUNTIME_GROUP, SUN_JAXWS_RUNTIME_ARTIFACT, gavToModel);
                if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                    String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                    return (SourceFile)new AddDependencyVisitor(SUN_JAXWS_RUNTIME_GROUP, SUN_JAXWS_RUNTIME_ARTIFACT, "2.3.2", null, resolvedScope, null, null, null, null, null).visit((Tree)s, (Object)ctx);
                }
            }
            return s;
        });
    }

    @Nullable
    private static Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId, Map<GroupArtifactVersion, MavenResolutionResult> gavToModels) {
        Scope maxScope = null;
        block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
            for (ResolvedDependency dependency : (List)entry.getValue()) {
                if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                if (!Scope.Compile.equals((Object)(maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey()))))) continue block0;
                return maxScope;
            }
        }
        return null;
    }

    @NonNull
    public String toString() {
        return "AddJaxwsRuntime()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxwsRuntime)) {
            return false;
        }
        AddJaxwsRuntime other = (AddJaxwsRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxwsRuntime;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

