/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateCollectionsUnmodifiableSet
extends Recipe {
    private static final MethodMatcher UNMODIFIABLE_SET = new MethodMatcher("java.util.Collections unmodifiableSet(java.util.Set)", true);
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", true);

    public String getDisplayName() {
        return "Use `Set.of(..)` in Java 9 or higher";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Replaces `unmodifiableSet(java.util.Set(java.util.Arrays asList(<args>)))` with `Set.Of(<args>)`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(UNMODIFIABLE_SET)});
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.NewClass newSet;
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (UNMODIFIABLE_SET.matches(method) && m.getArguments().get(0) instanceof J.NewClass && (newSet = (J.NewClass)m.getArguments().get(0)).getArguments() != null && newSet.getArguments().get(0) instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches((Expression)newSet.getArguments().get(0))) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeRemoveImport("java.util.Arrays");
                    this.maybeAddImport("java.util.Set");
                    StringJoiner setOf = new StringJoiner(", ", "Set.of(", ")");
                    List args = ((J.MethodInvocation)newSet.getArguments().get(0)).getArguments();
                    args.forEach(o -> setOf.add("#{any()}"));
                    return this.autoFormat(m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)setOf.toString()).imports(new String[]{"java.util.Set"}).build(), m.getCoordinates().replace(), args.toArray()), executionContext);
                }
                return m;
            }
        };
    }
}

