/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.template.SourceTemplate;

public class ApacheFileUtilsToJavaFiles
extends Recipe {
    public String getDisplayName() {
        return "Prefer `java.nio.file.Files`";
    }

    public String getDescription() {
        return "Prefer the Java standard library's `java.nio.file.Files` over third-party usage of apache's `apache.commons.io.FileUtils`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.commons.io.FileUtils");
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher readFileToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readFileToByteArray(java.io.File)");
            private final MethodMatcher readLinesToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File)");
            private final MethodMatcher readLinesWithCharsetToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File, java.nio.charset.Charset)");
            private final MethodMatcher readLinesWithCharsetIdToByteArrayMatcher = new MethodMatcher("org.apache.commons.io.FileUtils readLines(java.io.File, String)");

            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                JavaSourceFile sf = super.visitJavaSourceFile(cu, (Object)executionContext);
                if (sf != cu) {
                    this.maybeAddImport("java.nio.file.Files");
                    this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                }
                return sf;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (this.readFileToByteArrayMatcher.matches(mi)) {
                    return (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Files.readAllBytes(#{any(java.io.File)}.toPath())").imports(new String[]{"java.nio.file.Files"}).build(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                }
                if (this.readLinesToByteArrayMatcher.matches(mi)) {
                    return (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Files.readAllLines(#{any(java.io.File)}.toPath())").imports(new String[]{"java.nio.file.Files"}).build(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
                }
                if (this.readLinesWithCharsetToByteArrayMatcher.matches(mi)) {
                    return (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Files.readAllLines(#{any(java.io.File)}.toPath(), #{any(java.nio.charset.Charset)})").imports(new String[]{"java.nio.file.Files", "java.nio.charset.Charset"}).build(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)});
                }
                if (this.readLinesWithCharsetIdToByteArrayMatcher.matches(mi)) {
                    return (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Files.readAllLines(#{any(java.io.File)}.toPath(), Charset.forName(#{any(String)}))").imports(new String[]{"java.nio.file.Files", "java.nio.charset.Charset"}).build(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), mi.getArguments().get(1)});
                }
                return mi;
            }
        };
    }
}

