/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaListsNewCopyOnWriteArrayList
extends Recipe {
    private static final MethodMatcher NEW_ARRAY_LIST = new MethodMatcher("com.google.common.collect.Lists newCopyOnWriteArrayList()");
    private static final MethodMatcher NEW_ARRAY_LIST_ITERABLE = new MethodMatcher("com.google.common.collect.Lists newCopyOnWriteArrayList(java.lang.Iterable)");

    public String getDisplayName() {
        return "Prefer `new CopyOnWriteArrayList<>()`";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_ARRAY_LIST));
                this.doAfterVisit((TreeVisitor)new UsesMethod(NEW_ARRAY_LIST_ITERABLE));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newArrayList = JavaTemplate.builder(() -> (this).getCursor(), (String)"new CopyOnWriteArrayList<>()").imports(new String[]{"java.util.concurrent.CopyOnWriteArrayList"}).build();
            private final JavaTemplate newArrayListIterable = JavaTemplate.builder(() -> (this).getCursor(), (String)"new CopyOnWriteArrayList<>(#{any(java.lang.Iterable)})").imports(new String[]{"java.util.concurrent.CopyOnWriteArrayList"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_ARRAY_LIST.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.concurrent.CopyOnWriteArrayList");
                    return method.withTemplate((SourceTemplate)this.newArrayList, method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_ARRAY_LIST_ITERABLE.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.concurrent.CopyOnWriteArrayList");
                    return method.withTemplate((SourceTemplate)this.newArrayListIterable, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

