/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaSetsNewHashSet
extends Recipe {
    private static final MethodMatcher NEW_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newHashSet(..)");

    public String getDisplayName() {
        return "Prefer `new HashSet<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesMethod(NEW_HASH_SET);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newHashSet = JavaTemplate.builder(() -> (this).getCursor(), (String)"new HashSet<>()").imports(new String[]{"java.util.HashSet"}).build();
            private final JavaTemplate newHashSetIterable = JavaTemplate.builder(() -> (this).getCursor(), (String)"new HashSet<>(#{any(java.lang.Iterable)})").imports(new String[]{"java.util.HashSet"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_HASH_SET.matches(method)) {
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.HashSet");
                    if (method.getArguments().isEmpty() || !method.getArguments().isEmpty() && method.getArguments().get(0) instanceof J.Empty) {
                        return method.withTemplate((SourceTemplate)this.newHashSet, method.getCoordinates().replace(), new Object[0]);
                    }
                    if (method.getArguments().size() == 1 && TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Iterable"), (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                        return method.withTemplate((SourceTemplate)this.newHashSetIterable, method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                    }
                    this.maybeAddImport("java.util.Arrays");
                    JavaTemplate newHashSetVarargs = JavaTemplate.builder(() -> (this).getCursor(), (String)("new HashSet<>(Arrays.asList(" + method.getArguments().stream().map(a -> "#{any()}").collect(Collectors.joining(",")) + "))")).imports(new String[]{"java.util.Arrays"}).imports(new String[]{"java.util.HashSet"}).build();
                    return method.withTemplate((SourceTemplate)newHashSetVarargs, method.getCoordinates().replace(), method.getArguments().toArray());
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

