/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.maven;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindProperties;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UseMavenCompilerPluginReleaseConfiguration
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Release Version", description="The new value for the release configuration. This recipe prefers ${java.version} if defined.", example="11")
    private final String releaseVersion;

    public String getDisplayName() {
        return "Use Maven Compiler Plugin Release Configuration";
    }

    public String getDescription() {
        return "Replaces any explicit `source` or `target` configuration (if present) on the maven-compiler-plugin with `release`, and updates the `release` value if needed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag superVisit = super.visitTag(tag, (Object)ctx);
                if (!PLUGINS_MATCHER.matches(this.getCursor())) {
                    return superVisit;
                }
                Optional<Xml.Tag> maybeCompilerPlugin = superVisit.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && "org.apache.maven.plugins".equals(plugin.getChildValue("groupId").orElse(null)) && "maven-compiler-plugin".equals(plugin.getChildValue("artifactId").orElse(null))).findAny();
                Optional maybeCompilerPluginConfig = maybeCompilerPlugin.flatMap(it -> it.getChild("configuration"));
                if (!maybeCompilerPluginConfig.isPresent()) {
                    return superVisit;
                }
                Xml.Tag compilerPluginConfig = (Xml.Tag)maybeCompilerPluginConfig.get();
                Optional source = compilerPluginConfig.getChildValue("source");
                Optional target = compilerPluginConfig.getChildValue("target");
                Optional release = compilerPluginConfig.getChildValue("release");
                if (!(source.isPresent() || target.isPresent() || release.isPresent())) {
                    return superVisit;
                }
                Xml.Tag updated = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)superVisit, (Xml.Tag)compilerPluginConfig, child -> !"source".equals(child.getName()) && !"target".equals(child.getName()));
                if (updated != superVisit && source.map("${maven.compiler.source}"::equals).orElse(true).booleanValue() && target.map("${maven.compiler.target}"::equals).orElse(true).booleanValue()) {
                    return FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)updated, (Xml.Tag)maybeCompilerPlugin.get(), child -> !"configuration".equals(child.getName()) || !child.getChildren().isEmpty());
                }
                String releaseVersionValue = UseMavenCompilerPluginReleaseConfiguration.this.hasJavaVersionProperty((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)) ? "${java.version}" : UseMavenCompilerPluginReleaseConfiguration.this.releaseVersion;
                updated = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)updated, (Xml.Tag)compilerPluginConfig, (Xml.Tag)Xml.Tag.build((String)("<release>" + releaseVersionValue + "</release>")), (Cursor)this.getCursor().getParentOrThrow());
                return updated;
            }
        };
    }

    private boolean hasJavaVersionProperty(Xml.Document xml) {
        return xml != new FindProperties("java.version").getVisitor().visit((Tree)xml, (Object)new InMemoryExecutionContext());
    }

    @ConstructorProperties(value={"releaseVersion"})
    public UseMavenCompilerPluginReleaseConfiguration(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @NonNull
    public String toString() {
        return "UseMavenCompilerPluginReleaseConfiguration(releaseVersion=" + this.getReleaseVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseMavenCompilerPluginReleaseConfiguration)) {
            return false;
        }
        UseMavenCompilerPluginReleaseConfiguration other = (UseMavenCompilerPluginReleaseConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$releaseVersion = this.getReleaseVersion();
        String other$releaseVersion = other.getReleaseVersion();
        return !(this$releaseVersion == null ? other$releaseVersion != null : !this$releaseVersion.equals(other$releaseVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseMavenCompilerPluginReleaseConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $releaseVersion = this.getReleaseVersion();
        result = result * 59 + ($releaseVersion == null ? 43 : $releaseVersion.hashCode());
        return result;
    }
}

