/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;

    public String getDisplayName() {
        return "Upgrade Java version";
    }

    public String getDescription() {
        return "Upgrade build plugin configuration to use the specified Java version. This recipe changes maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        String newVersion = this.version.toString();
        Optional<JavaVersion> currentMarker = before.stream().map(it -> it.getMarkers().findFirst(JavaVersion.class)).filter(Optional::isPresent).map(Optional::get).findAny();
        if (!currentMarker.isPresent() || currentMarker.get().getMajorVersion() >= this.version) {
            return before;
        }
        JavaVersion updatedMarker = currentMarker.get().withSourceCompatibility(newVersion).withTargetCompatibility(newVersion);
        return ListUtils.map(before, sourceFile -> sourceFile.getMarkers().findFirst(JavaVersion.class).map(version -> (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().computeByType((Marker)version, (v, acc) -> updatedMarker))).orElse((SourceFile)sourceFile));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)executionContext);
                if (!this.isPropertyTag()) {
                    return t;
                }
                if (!"java.version".equals(t.getName()) && !"maven.compiler.source".equals(t.getName()) && !"maven.compiler.target".equals(t.getName()) || tag.getValue().isPresent() && ((String)tag.getValue().get()).startsWith("${")) {
                    return t;
                }
                float value = tag.getValue().map(Float::parseFloat).orElse(Float.valueOf(0.0f)).floatValue();
                if (value >= (float)UpgradeJavaVersion.this.version.intValue()) {
                    return t;
                }
                return t.withValue(String.valueOf(UpgradeJavaVersion.this.version));
            }
        };
    }

    @ConstructorProperties(value={"version"})
    public UpgradeJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

