/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public final class ApacheIOUtilsUseExplicitCharset
extends Recipe {
    private static final Map<MethodMatcher, String> MATCHER_TEMPLATES = new HashMap<MethodMatcher, String>();
    private static final MethodMatcher STRING_GET_BYTES = new MethodMatcher("org.apache.commons.io.IOUtils toByteArray(java.lang.String)");
    @Option(displayName="Default encoding", description="The default encoding to use, must be a standard charset.", example="UTF_8", required=false)
    @Nullable
    private final String encoding;

    public String getDisplayName() {
        return "Use IOUtils method that include  their charset encoding";
    }

    public String getDescription() {
        return "Use `IOUtils` method invocations that include the charset encoding instead of using the deprecated versions that do not include a charset encoding. (e.g. converts `IOUtils.readLines(inputStream)` to `IOUtils.readLines(inputStream, StandardCharsets.UTF_8)`.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"encoding", (String)"Invalid encoding must be a standard Charset", (Object)this.encoding, e -> e == null || e.matches("US_ASCII|ISO_8859_1|UTF_8|UTF_16BE|UTF_16LE|UTF_16")));
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.apache.commons.io.IOUtils", Boolean.valueOf(false));
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final Supplier<JavaParser> parserSupplier = () -> JavaParser.fromJavaVersion().classpath(new String[]{"commons-io"}).build();

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (STRING_GET_BYTES.matches(mi)) {
                    mi = mi.withSelect((Expression)method.getArguments().get(0));
                    mi = mi.withMethodType(mi.getMethodType().withName("getBytes"));
                    mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(String)}.getBytes(StandardCharsets.#{})}").javaParser(this.parserSupplier).imports(new String[]{"java.nio.charset.StandardCharsets"}).build(), mi.getCoordinates().replaceMethod(), new Object[]{mi.getArguments().get(0), ApacheIOUtilsUseExplicitCharset.this.encoding == null ? "UTF_8" : ApacheIOUtilsUseExplicitCharset.this.encoding});
                } else {
                    for (Map.Entry entry : MATCHER_TEMPLATES.entrySet()) {
                        if (!((MethodMatcher)entry.getKey()).matches(mi)) continue;
                        ArrayList<String> args = new ArrayList<String>(mi.getArguments());
                        args.add(ApacheIOUtilsUseExplicitCharset.this.encoding == null ? "UTF_8" : ApacheIOUtilsUseExplicitCharset.this.encoding);
                        mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)((String)entry.getValue())).javaParser(this.parserSupplier).imports(new String[]{"java.nio.charset.StandardCharsets"}).build(), mi.getCoordinates().replaceMethod(), args.toArray());
                    }
                }
                if (method != mi) {
                    this.maybeAddImport("java.nio.charset.StandardCharsets");
                }
                return mi;
            }
        };
    }

    @ConstructorProperties(value={"encoding"})
    public ApacheIOUtilsUseExplicitCharset(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @NonNull
    public String toString() {
        return "ApacheIOUtilsUseExplicitCharset(encoding=" + this.getEncoding() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApacheIOUtilsUseExplicitCharset)) {
            return false;
        }
        ApacheIOUtilsUseExplicitCharset other = (ApacheIOUtilsUseExplicitCharset)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        return !(this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ApacheIOUtilsUseExplicitCharset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        return result;
    }

    static {
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils copy(java.io.InputStream, java.io.Writer)"), "copy(#{any(java.io.InputStream)}, #{any(java.io.Writer)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils copy(java.io.Reader, java.io.OutputStream)"), "copy(#{any(java.io.InputStream)}, #{any(java.io.OutputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils readLines(java.io.InputStream)"), "readLines(#{any(java.io.InputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toByteArray(java.io.Reader)"), "toByteArray(#{any(java.io.Reader)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toCharArray(java.io.InputStream)"), "toCharArray(#{any(java.io.InputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toInputStream(java.lang.CharSequence)"), "toInputStream(#{any(java.lang.CharSequence)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toInputStream(java.lang.String)"), "toInputStream(#{any(java.lang.String)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toString(byte[])"), "toString(#{anyArray(byte)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toString(java.io.InputStream)"), "toString(#{any(java.io.InputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toString(java.net.URI)"), "toString(#{any(java.net.URI)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils toString(java.net.URL)"), "toString(#{any(java.net.URL)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils write(byte[], java.io.Writer)"), "write(#{anyArray(byte)}, #{any(java.io.Writer)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils write(char[], java.io.OutputStream)"), "write(#{anyArray(char)}, #{any(java.io.OutputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils write(java.lang.CharSequence, java.io.OutputStream)"), "write(#{any(java.lang.CharSequence)}, #{any(java.io.OutputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils write(java.lang.String, java.io.OutputStream)"), "write(#{any(java.lang.String)}, #{any(java.io.OutputStream)}, StandardCharsets.#{})");
        MATCHER_TEMPLATES.put(new MethodMatcher("org.apache.commons.io.IOUtils write(java.lang.StringBuffer, java.io.OutputStream)"), "write(#{any(java.lang.StringBuffer)}, #{any(java.io.OutputStream)}, StandardCharsets.#{})");
    }
}

