/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class PreferJavaUtilOptionalOrSupplier
extends Recipe {
    static final MethodMatcher METHOD_MATCHER = new MethodMatcher("com.google.common.base.Optional or(com.google.common.base.Optional)");

    public String getDisplayName() {
        return "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)`";
    }

    public String getDescription() {
        return "Prefer `java.util.Optional#or(Supplier<T extends java.util.Optional<T>>)` over `com.google.common.base.Optional#or(com.google.common.base.Optional).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesType("com.google.common.base.Optional", Boolean.valueOf(false))});
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(METHOD_MATCHER);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new PreferJavaUtilOptionalOrSupplierVisitor();
    }

    private static class PreferJavaUtilOptionalOrSupplierVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private PreferJavaUtilOptionalOrSupplierVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeAddImport("java.util.Optional");
            this.maybeRemoveImport("com.google.common.base.Optional");
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation j = super.visitMethodInvocation(method, (Object)ctx);
            if (METHOD_MATCHER.matches(method)) {
                j = (J.MethodInvocation)j.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((PreferJavaUtilOptionalOrSupplierVisitor)this).getCursor(), (String)"#{any(java.util.Optional)}.or(() -> #{any(java.util.Optional)})").imports(new String[]{"java.util.Optional"}).build(), method.getCoordinates().replace(), new Object[]{j.getSelect(), j.getArguments().get(0)});
            }
            return j;
        }
    }
}

