/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="0.2.0")
public class AddJDeprScanPlugin
extends Recipe {
    public String getDisplayName() {
        return "Add JDeprScan Maven Plug-in";
    }

    public String getDescription() {
        return "JDeprScan scans class files for uses of deprecated APIs.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return ListUtils.map(before, s -> {
            if ("pom.xml".equals(s.getSourcePath().toString()) && s.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) {
                return (SourceFile)new AddJDeprScanPluginVisitor().visit((Tree)s, ctx);
            }
            return s;
        });
    }

    private static class AddJDeprScanPluginVisitor
    extends MavenVisitor<ExecutionContext> {
        private AddJDeprScanPluginVisitor() {
        }

        public Xml visitDocument(Xml.Document document, ExecutionContext o) {
            this.doAfterVisit((Recipe)new AddPlugin("org.apache.maven.plugins", "maven-jdeprscan-plugin", "3.0.0-alpha-1", "<configuration>\n   <release>11</release>\n</configuration>", null, null));
            return document;
        }
    }
}

