/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateCollectionsSingletonSet
extends Recipe {
    private static final MethodMatcher SINGLETON_SET = new MethodMatcher("java.util.Collections singleton(..)", true);

    public String getDisplayName() {
        return "Prefer `Set.of(..)`";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Prefer `Set.Of(..)` instead of using `Collections.singleton()` in Java 9 or higher.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SINGLETON_SET)});
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (SINGLETON_SET.matches(method)) {
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeAddImport("java.util.Set");
                    return this.autoFormat(m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"Set.of(#{any()})").imports(new String[]{"java.util.Set"}).build(), m.getCoordinates().replace(), new Object[]{m.getArguments().get(0)}), ctx);
                }
                return m;
            }
        };
    }
}

