/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MigrateURLEncoderEncode
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.net.URLEncoder encode(String)");

    public String getDisplayName() {
        return "Use `java.net.URLEncoder#encode(String, StandardCharsets.UTF_8)`";
    }

    public String getDescription() {
        return "`java.net.URLEncoder#encode(String)` is platform-dependent. It's advised to specify an encoding.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(MATCHER);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateURLEncoderEncodeVisitor();
    }

    private static class MigrateURLEncoderEncodeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateURLEncoderEncodeVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (MATCHER.matches(m)) {
                m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((MigrateURLEncoderEncodeVisitor)this).getCursor(), (String)"#{any(String)}, StandardCharsets.UTF_8").imports(new String[]{"java.nio.charset.StandardCharsets"}).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                this.doAfterVisit((TreeVisitor)new AddImport("java.nio.charset.StandardCharsets", null, false));
            }
            return super.visitMethodInvocation(m, (Object)ctx);
        }
    }
}

