/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.template.SourceTemplate;

public class UseMapOf
extends Recipe {
    private static final MethodMatcher NEW_HASH_MAP = new MethodMatcher("java.util.HashMap <constructor>()", true);
    private static final MethodMatcher MAP_PUT = new MethodMatcher("java.util.Map put(..)", true);

    public String getDisplayName() {
        return "Use `Map.of(..)` where possible";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "This succinct syntax was introduced in Java 10.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(NEW_HASH_MAP);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                Statement statement;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                J.Block body = n.getBody();
                if (NEW_HASH_MAP.matches(n) && body != null && body.getStatements().size() == 1 && (statement = (Statement)body.getStatements().get(0)) instanceof J.Block) {
                    ArrayList args = new ArrayList();
                    StringJoiner mapOf = new StringJoiner(", ", "Map.of(", ")");
                    for (Statement stat : ((J.Block)statement).getStatements()) {
                        if (stat instanceof J.MethodInvocation && MAP_PUT.matches((Expression)stat)) {
                            J.MethodInvocation put = (J.MethodInvocation)stat;
                            args.addAll(put.getArguments());
                            mapOf.add("#{}");
                            mapOf.add("#{}");
                            continue;
                        }
                        return n;
                    }
                    this.maybeRemoveImport("java.util.HashMap");
                    this.maybeAddImport("java.util.Map");
                    return this.autoFormat(n.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)mapOf.toString()).imports(new String[]{"java.util.Map"}).build(), n.getCoordinates().replace(), args.toArray()), ctx);
                }
                return n;
            }
        };
    }
}

