/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class UseEnumSetOf
extends Recipe {
    private static final MethodMatcher SET_OF = new MethodMatcher("java.util.Set of(..)", true);

    public String getDisplayName() {
        return "Use `EnumSet of(..)`";
    }

    public String getDescription() {
        return "Replaces `Set of(..)` with `EnumSet of(..)` if the arguments are enums.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesJavaVersion(9));
                this.doAfterVisit((TreeVisitor)new UsesMethod(SET_OF));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                Cursor parent;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)executionContext);
                if (SET_OF.matches(method) && method.getType() instanceof JavaType.Parameterized && !TypeUtils.isOfClassType((JavaType)method.getType(), (String)"java.util.EnumSet") && !((parent = this.getCursor().dropParentUntil(is -> is instanceof J.Assignment || is instanceof J.VariableDeclarations || is instanceof J.Block)).getValue() instanceof J.Block)) {
                    JavaType type;
                    JavaType javaType = type = parent.getValue() instanceof J.Assignment ? ((J.Assignment)parent.getValue()).getType() : ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parent.getValue()).getVariables().get(0)).getType();
                    if (this.isAssignmentSetOfEnum(type)) {
                        this.maybeAddImport("java.util.EnumSet");
                        StringJoiner setOf = new StringJoiner(", ", "EnumSet.of(", ")");
                        List args = m.getArguments();
                        args.forEach(o -> setOf.add("#{any()}"));
                        return (J.MethodInvocation)this.autoFormat((J)((J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"EnumSet.of(#{any()})").imports(new String[]{"java.util.EnumSet"}).build(), m.getCoordinates().replace(), args.toArray())), executionContext);
                    }
                }
                return m;
            }

            private boolean isAssignmentSetOfEnum(@Nullable JavaType type) {
                JavaType.Parameterized parameterized;
                if (type instanceof JavaType.Parameterized && TypeUtils.isOfClassType((JavaType)(parameterized = (JavaType.Parameterized)type).getType(), (String)"java.util.Set")) {
                    return ((JavaType.Parameterized)type).getTypeParameters().stream().filter(o -> o instanceof JavaType.Class).map(o -> (JavaType.Class)o).anyMatch(o -> o.getKind() == JavaType.FullyQualified.Kind.Enum);
                }
                return false;
            }
        };
    }
}

