/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.lang;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class ApacheCommonsStringUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsStringUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.apache.commons.lang.ApacheCommonsStringUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbbreviateRecipe(), new CapitalizeRecipe(), new DefaultStringRecipe(), new DefaultStringFallbackRecipe(), new DeleteWhitespaceRecipe(), new EqualsIgnoreCaseRecipe(), new EqualsRecipe(), new IsAlphanumericRecipe(), new IsAlphaRecipe(), new IsEmptyRecipe(), new LowercaseRecipe(), new RemoveEndRecipe(), new ReplaceRecipe(), new ReverseRecipe(), new SplitRecipe(), new StripRecipe(), new TrimToEmptyRecipe(), new TrimToNullRecipe(), new TrimRecipe(), new UppercaseRecipe()});
    }

    private static class AbbreviateRecipe
    extends Recipe {
        private AbbreviateRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Abbreviate`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Abbreviate {\n    \n    @BeforeTemplate\n    String before(String s1, int width) {\n        return StringUtils.abbreviate(s1, width);\n    }\n    \n    @AfterTemplate\n    String after(String s, int width) {\n        return (s == null || s.length() <= width ? s : s.substring(0, width - 3) + \"...\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s1, width) -> StringUtils.abbreviate((String)s1, (int)width)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, width) -> s == null || s.length() <= width ? s : s.substring(0, width - 3) + "...").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class CapitalizeRecipe
    extends Recipe {
        private CapitalizeRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Capitalize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class Capitalize {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.capitalize(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null || s.isEmpty() || Character.isTitleCase(s.charAt(0)) ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.capitalize((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null || s.isEmpty() || Character.isTitleCase(s.charAt(0)) ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class DefaultStringRecipe
    extends Recipe {
        private DefaultStringRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.DefaultString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DefaultString {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.defaultString(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return Objects.toString(s, \"\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.defaultString((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> Objects.toString(s, "")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeAddImport("java.util.Objects");
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class DefaultStringFallbackRecipe
    extends Recipe {
        private DefaultStringFallbackRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.DefaultStringFallback`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DefaultStringFallback {\n    \n    @BeforeTemplate\n    String before(String s, String nullDefault) {\n        return StringUtils.defaultString(s, nullDefault);\n    }\n    \n    @AfterTemplate\n    String after(String s, String nullDefault) {\n        return Objects.toString(s, nullDefault);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, nullDefault) -> StringUtils.defaultString((String)s, (String)nullDefault)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, nullDefault) -> Objects.toString(s, nullDefault)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeAddImport("java.util.Objects");
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class DeleteWhitespaceRecipe
    extends Recipe {
        private DeleteWhitespaceRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.DeleteWhitespace`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DeleteWhitespace {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.deleteWhitespace(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.replaceAll(\"\\s+\", \"\"));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.deleteWhitespace((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.replaceAll("\\s+", "")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class EqualsIgnoreCaseRecipe
    extends Recipe {
        private EqualsIgnoreCaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.EqualsIgnoreCase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class EqualsIgnoreCase {\n    \n    @BeforeTemplate\n    boolean before(String s, String other) {\n        return StringUtils.equalsIgnoreCase(s, other);\n    }\n    \n    @AfterTemplate\n    boolean after(String s, String other) {\n        return (s == null && other == null || s != null && s.equalsIgnoreCase(other));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)other)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, other) -> s == null && other == null || s != null && s.equalsIgnoreCase((String)other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class EqualsRecipe
    extends Recipe {
        private EqualsRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Equals`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Equals {\n    \n    @BeforeTemplate\n    boolean before(String s, String other) {\n        return StringUtils.equals(s, other);\n    }\n    \n    @AfterTemplate\n    boolean after(String s, String other) {\n        return Objects.equals(s, other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equals((CharSequence)s, (CharSequence)other)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, other) -> Objects.equals(s, other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeAddImport("java.util.Objects");
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class IsAlphanumericRecipe
    extends Recipe {
        private IsAlphanumericRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.IsAlphanumeric`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class IsAlphanumeric {\n    \n    @BeforeTemplate\n    boolean before(String s) {\n        return StringUtils.isAlphanumeric(s);\n    }\n    \n    @AfterTemplate\n    boolean after(String s) {\n        return (s != null && !s.isEmpty() && s.chars().allMatch(Character::isLetterOrDigit));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.isAlphanumeric((CharSequence)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s != null && !s.isEmpty() && s.chars().allMatch(Character::isLetterOrDigit)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class IsAlphaRecipe
    extends Recipe {
        private IsAlphaRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.IsAlpha`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class IsAlpha {\n    \n    @BeforeTemplate\n    boolean before(String s) {\n        return StringUtils.isAlpha(s);\n    }\n    \n    @AfterTemplate\n    boolean after(String s) {\n        return (s != null && !s.isEmpty() && s.chars().allMatch(Character::isLetter));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.isAlpha((CharSequence)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s != null && !s.isEmpty() && s.chars().allMatch(Character::isLetter)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class IsEmptyRecipe
    extends Recipe {
        private IsEmptyRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.IsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class IsEmpty {\n    \n    @BeforeTemplate\n    boolean before(String s) {\n        return StringUtils.isEmpty(s);\n    }\n    \n    @AfterTemplate\n    boolean after(String s) {\n        return (s == null || s.isEmpty());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.isEmpty((CharSequence)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null || s.isEmpty()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class LowercaseRecipe
    extends Recipe {
        private LowercaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Lowercase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class Lowercase {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.lowerCase(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.toLowerCase());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.lowerCase((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toLowerCase()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class RemoveEndRecipe
    extends Recipe {
        private RemoveEndRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.RemoveEnd`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class RemoveEnd {\n    \n    @BeforeTemplate\n    String before(String s, String end) {\n        return StringUtils.removeEnd(s, end);\n    }\n    \n    @AfterTemplate\n    String after(String s, String end) {\n        return (s == null || s.isEmpty() || end == null || end.isEmpty() || !s.endsWith(end) ? s : s.substring(0, s.length() - end.length()));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, end) -> StringUtils.removeEnd((String)s, (String)end)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, end) -> s == null || s.isEmpty() || end == null || end.isEmpty() || !s.endsWith((String)end) ? s : s.substring(0, s.length() - end.length())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(1), matcher.parameter(0), matcher.parameter(1), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class ReplaceRecipe
    extends Recipe {
        private ReplaceRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Replace`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Replace {\n    \n    @BeforeTemplate\n    String before(String s, String search, String replacement) {\n        return StringUtils.replace(s, search, replacement);\n    }\n    \n    @AfterTemplate\n    String after(String s, String search, String replacement) {\n        return (s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace(search, replacement));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, search, replacement) -> StringUtils.replace((String)s, (String)search, (String)replacement)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, search, replacement) -> s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace((CharSequence)search, (CharSequence)replacement)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class ReverseRecipe
    extends Recipe {
        private ReverseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Reverse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Reverse {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.reverse(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : new StringBuilder(s).reverse().toString());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.reverse((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : new StringBuilder((String)s).reverse().toString()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class SplitRecipe
    extends Recipe {
        private SplitRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Split`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Split {\n    \n    @BeforeTemplate\n    String[] before(String s) {\n        return StringUtils.split(s);\n    }\n    \n    @AfterTemplate\n    String[] after(String s) {\n        return (s == null ? null : s.split(\"\\s+\"));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.split((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.split("\\s+")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class StripRecipe
    extends Recipe {
        private StripRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Strip`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Strip {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.strip(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.strip((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class TrimToEmptyRecipe
    extends Recipe {
        private TrimToEmptyRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.TrimToEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class TrimToEmpty {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.trimToEmpty(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? \"\" : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.trimToEmpty((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? "" : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class TrimToNullRecipe
    extends Recipe {
        private TrimToNullRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.TrimToNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class TrimToNull {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.trimToNull(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null || s.trim().isEmpty() ? null : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.trimToNull((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null || s.trim().isEmpty() ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class TrimRecipe
    extends Recipe {
        private TrimRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Trim`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Trim {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.trim(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.trim((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    private static class UppercaseRecipe
    extends Recipe {
        private UppercaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsStringUtils.Uppercase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Uppercase {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.upperCase(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.toUpperCase());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){
                final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.upperCase((String)s)).build();
                final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toUpperCase()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        this.doAfterVisit(new ShortenFullyQualifiedTypeReferences().getVisitor());
                        this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                        this.doAfterVisit((TreeVisitor)new SimplifyBooleanExpressionVisitor());
                        return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }
}

