/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public final class UseStringIsEmptyRecipe
extends Recipe {
    public String getDisplayName() {
        return "Refaster template `UseStringIsEmpty`";
    }

    public String getDescription() {
        return "Recipe created for the following Refaster template:\n```java\npublic class UseStringIsEmpty {\n    \n    @BeforeTemplate\n    boolean before(String s) {\n        return s.length() > 0;\n    }\n    \n    @AfterTemplate\n    boolean after(String s) {\n        return !s.isEmpty();\n    }\n}\n```\n.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate before = JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> s.length() > 0).build();
            final JavaTemplate after = JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> !s.isEmpty()).build();

            public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)});
                }
                return super.visitBinary(elem, (Object)ctx);
            }
        };
    }
}

