/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import io.micrometer.core.instrument.util.StringUtils;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.table.JavaVersionPerFile;
import org.openrewrite.java.migrate.table.JavaVersionPerSourceSet;
import org.openrewrite.java.migrate.table.JavaVersionRow;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public final class AboutJavaVersion
extends ScanningRecipe<Map<ProjectSourceSet, JavaVersionRow>> {
    private final transient JavaVersionPerFile javaVersionPerFile = new JavaVersionPerFile((Recipe)this);
    private final transient JavaVersionPerSourceSet javaVersionPerSourceSet = new JavaVersionPerSourceSet((Recipe)this);
    @Option(required=false, description="Only mark the Java version when this type is in use.", example="lombok.val")
    @Nullable
    private final String whenUsesType;

    public String getDisplayName() {
        return "Find which Java version is in use";
    }

    public String getDescription() {
        return "A diagnostic for studying the distribution of Java language version levels (both source and target compatibility across files and source sets).";
    }

    public Map<ProjectSourceSet, JavaVersionRow> getInitialValue(ExecutionContext ctx) {
        return new HashMap<ProjectSourceSet, JavaVersionRow>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<ProjectSourceSet, JavaVersionRow> sourceSetVersion) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree sourceFile, ExecutionContext ctx) {
                sourceFile.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> sourceFile.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> sourceFile.getMarkers().findFirst(JavaVersion.class).ifPresent(version -> sourceSetVersion.put(new ProjectSourceSet((JavaProject)javaProject, (JavaSourceSet)sourceSet), new JavaVersionRow(javaProject.getProjectName(), sourceSet.getName(), version.getCreatedBy(), version.getVmVendor(), version.getSourceCompatibility(), Integer.toString(version.getMajorReleaseVersion()), version.getTargetCompatibility())))));
                return sourceFile;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Map<ProjectSourceSet, JavaVersionRow> unused) {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree cu, ExecutionContext ctx) {
                if (!(cu instanceof JavaSourceFile)) {
                    return cu;
                }
                return cu.getMarkers().findFirst(JavaVersion.class).map(version -> {
                    String projectName = cu.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                    String sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("");
                    AboutJavaVersion.this.javaVersionPerFile.insertRow(ctx, new JavaVersionRow(projectName, sourceSet, version.getCreatedBy(), version.getVmVendor(), version.getSourceCompatibility(), Integer.toString(version.getMajorReleaseVersion()), version.getTargetCompatibility()));
                    return SearchResult.found((Tree)cu, (String)("Java version: " + version.getMajorVersion()));
                }).orElse(cu);
            }
        };
        if (StringUtils.isNotBlank((String)this.whenUsesType)) {
            visitor = Preconditions.check((TreeVisitor)new UsesType(this.whenUsesType, Boolean.valueOf(false)), (TreeVisitor)visitor);
        }
        return visitor;
    }

    @ConstructorProperties(value={"whenUsesType"})
    public AboutJavaVersion(@Nullable String whenUsesType) {
        this.whenUsesType = whenUsesType;
    }

    public JavaVersionPerFile getJavaVersionPerFile() {
        return this.javaVersionPerFile;
    }

    public JavaVersionPerSourceSet getJavaVersionPerSourceSet() {
        return this.javaVersionPerSourceSet;
    }

    @Nullable
    public String getWhenUsesType() {
        return this.whenUsesType;
    }

    @NonNull
    public String toString() {
        return "AboutJavaVersion(javaVersionPerFile=" + (Object)((Object)this.getJavaVersionPerFile()) + ", javaVersionPerSourceSet=" + (Object)((Object)this.getJavaVersionPerSourceSet()) + ", whenUsesType=" + this.getWhenUsesType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AboutJavaVersion)) {
            return false;
        }
        AboutJavaVersion other = (AboutJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$whenUsesType = this.getWhenUsesType();
        String other$whenUsesType = other.getWhenUsesType();
        return !(this$whenUsesType == null ? other$whenUsesType != null : !this$whenUsesType.equals(other$whenUsesType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AboutJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $whenUsesType = this.getWhenUsesType();
        result = result * 59 + ($whenUsesType == null ? 43 : $whenUsesType.hashCode());
        return result;
    }

    static final class ProjectSourceSet {
        private final JavaProject javaProject;
        private final JavaSourceSet javaSourceSet;

        @ConstructorProperties(value={"javaProject", "javaSourceSet"})
        public ProjectSourceSet(JavaProject javaProject, JavaSourceSet javaSourceSet) {
            this.javaProject = javaProject;
            this.javaSourceSet = javaSourceSet;
        }

        public JavaProject getJavaProject() {
            return this.javaProject;
        }

        public JavaSourceSet getJavaSourceSet() {
            return this.javaSourceSet;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectSourceSet)) {
                return false;
            }
            ProjectSourceSet other = (ProjectSourceSet)o;
            JavaProject this$javaProject = this.getJavaProject();
            JavaProject other$javaProject = other.getJavaProject();
            if (this$javaProject == null ? other$javaProject != null : !this$javaProject.equals(other$javaProject)) {
                return false;
            }
            JavaSourceSet this$javaSourceSet = this.getJavaSourceSet();
            JavaSourceSet other$javaSourceSet = other.getJavaSourceSet();
            return !(this$javaSourceSet == null ? other$javaSourceSet != null : !this$javaSourceSet.equals(other$javaSourceSet));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaProject $javaProject = this.getJavaProject();
            result = result * 59 + ($javaProject == null ? 43 : $javaProject.hashCode());
            JavaSourceSet $javaSourceSet = this.getJavaSourceSet();
            result = result * 59 + ($javaSourceSet == null ? 43 : $javaSourceSet.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AboutJavaVersion.ProjectSourceSet(javaProject=" + this.getJavaProject() + ", javaSourceSet=" + this.getJavaSourceSet() + ")";
        }
    }
}

