/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.AbstractRefasterJavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class ApacheCommonsFileUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsFileUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.apache.commons.io.ApacheCommonsFileUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new GetFileRecipe()});
    }

    private static class GetFileRecipe
    extends Recipe {
        private GetFileRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `ApacheCommonsFileUtils.GetFile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class GetFile {\n    \n    @BeforeTemplate\n    File before(String name) {\n        return FileUtils.getFile(name);\n    }\n    \n    @AfterTemplate\n    File after(String name) {\n        return new File(name);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", name -> FileUtils.getFile((String[])new String[]{name})).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", name -> new File((String)name)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.io.FileUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("org.apache.commons.io.FileUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.io.FileUtils getFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

