/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.AbstractRefasterJavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public final class StringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`StringRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.lang.StringRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new RedundantCallRecipe(), new IndexOfStringRecipe(), new IndexOfCharRecipe(), new UseEqualsIgnoreCaseRecipe()});
    }

    static class RedundantCallRecipe
    extends Recipe {
        RedundantCallRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `StringRules.RedundantCall`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"StringOperationCanBeSimplified\")\nstatic class RedundantCall {\n    \n    @BeforeTemplate\n    public String start(String string) {\n        return string.substring(0, string.length());\n    }\n    \n    @BeforeTemplate\n    public String startAndEnd(String string) {\n        return string.substring(0);\n    }\n    \n    @BeforeTemplate\n    public String toString(String string) {\n        return string.toString();\n    }\n    \n    @AfterTemplate\n    public String self(String string) {\n        return string;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> start = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"start", string -> string.substring(0, string.length())).build());
                Supplier<JavaTemplate> startAndEnd = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"startAndEnd", string -> string.substring(0)).build());
                Supplier<JavaTemplate> toString = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"toString", string -> string.toString()).build());
                Supplier<JavaTemplate> self = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"self", string -> string).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.start, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.self, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    matcher = this.matcher(this.startAndEnd, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.self, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    matcher = this.matcher(this.toString, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.self, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String substring(..)"), new UsesMethod("java.lang.String length(..)")}), new UsesMethod("java.lang.String substring(..)"), new UsesMethod("java.lang.String toString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    static class IndexOfStringRecipe
    extends Recipe {
        IndexOfStringRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `StringRules.IndexOfString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"StringOperationCanBeSimplified\")\nstatic class IndexOfString {\n    \n    @BeforeTemplate\n    public int indexOfZero(String string, String test) {\n        return string.indexOf(test, 0);\n    }\n    \n    @AfterTemplate\n    public int indexOf(String string, String test) {\n        return string.indexOf(test);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> indexOfZero = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"indexOfZero", (string, test) -> string.indexOf((String)test, 0)).build());
                Supplier<JavaTemplate> indexOf = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"indexOf", (string, test) -> string.indexOf((String)test)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.indexOfZero, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.indexOf, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)"), (TreeVisitor)javaVisitor);
        }
    }

    static class IndexOfCharRecipe
    extends Recipe {
        IndexOfCharRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `StringRules.IndexOfChar`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"StringOperationCanBeSimplified\")\nstatic class IndexOfChar {\n    \n    @BeforeTemplate\n    public int indexOfZero(String string, char test) {\n        return string.indexOf(test, 0);\n    }\n    \n    @AfterTemplate\n    public int indexOf(String string, char test) {\n        return string.indexOf(test);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> indexOfZero = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"indexOfZero", (string, test) -> string.indexOf(test.charValue(), 0)).build());
                Supplier<JavaTemplate> indexOf = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"indexOf", (string, test) -> string.indexOf(test.charValue())).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.indexOfZero, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.indexOf, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String indexOf(..)"), (TreeVisitor)javaVisitor);
        }
    }

    static class UseEqualsIgnoreCaseRecipe
    extends Recipe {
        UseEqualsIgnoreCaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `StringRules.UseEqualsIgnoreCase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"StringOperationCanBeSimplified\")\nstatic class UseEqualsIgnoreCase {\n    \n    @BeforeTemplate\n    public boolean bothLowerCase(String string, String test) {\n        return string.toLowerCase().equals(test.toLowerCase());\n    }\n    \n    @BeforeTemplate\n    public boolean bothUpperCase(String string, String test) {\n        return string.toUpperCase().equals(test.toUpperCase());\n    }\n    \n    @AfterTemplate\n    public boolean equalsIgnoreCase(String string, String test) {\n        return string.equalsIgnoreCase(test);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> bothLowerCase = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"bothLowerCase", (string, test) -> string.toLowerCase().equals(test.toLowerCase())).build());
                Supplier<JavaTemplate> bothUpperCase = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"bothUpperCase", (string, test) -> string.toUpperCase().equals(test.toUpperCase())).build());
                Supplier<JavaTemplate> equalsIgnoreCase = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"equalsIgnoreCase", (string, test) -> string.equalsIgnoreCase((String)test)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.bothLowerCase, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.equalsIgnoreCase, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    matcher = this.matcher(this.bothUpperCase, this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.apply(this.equalsIgnoreCase, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String equals(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String toLowerCase(..)"), new UsesMethod("java.lang.String toUpperCase(..)")})}), (TreeVisitor)javaVisitor);
        }
    }
}

