/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.ChangeDependency;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class AddJaxbRuntime
extends Recipe {
    private static final String JAKARTA_API_GROUP = "jakarta.xml.bind";
    private static final String JAKARTA_API_ARTIFACT = "jakarta.xml.bind-api";
    private static final String SUN_JAXB_RUNTIME_GROUP = "com.sun.xml.bind";
    private static final String SUN_JAXB_RUNTIME_ARTIFACT = "jaxb-impl";
    private static final String GLASSFISH_JAXB_RUNTIME_GROUP = "org.glassfish.jaxb";
    private static final String GLASSFISH_JAXB_RUNTIME_ARTIFACT = "jaxb-runtime";
    @Option(displayName="JAXB run-time", description="Which implementation of the JAXB run-time that will be added to maven projects that have transitive dependencies on the JAXB API", valid={"glassfish", "sun"}, example="glassfish")
    private final String runtime;

    public String getDisplayName() {
        return "Use latest JAXB API and runtime for Jakarta EE 8";
    }

    public String getDescription() {
        return "Update build files to use the latest JAXB runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater. The recipe will add a JAXB run-time, in Gradle `compileOnly`+`testImplementation` and Maven `provided` scope, to any project that has a transitive dependency on the JAXB API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("javax", "jakarta", "javaee", "jaxb", "glassfish", "java11"));
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AddJaxbRuntimeGradle(this.runtime), new AddJaxbRuntimeMaven(this.runtime)});
    }

    @ConstructorProperties(value={"runtime"})
    public AddJaxbRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    @NonNull
    public String toString() {
        return "AddJaxbRuntime(runtime=" + this.getRuntime() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJaxbRuntime)) {
            return false;
        }
        AddJaxbRuntime other = (AddJaxbRuntime)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$runtime = this.getRuntime();
        String other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddJaxbRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
        return result;
    }

    static final class AddJaxbRuntimeGradle
    extends Recipe {
        private final String runtime;

        public String getDisplayName() {
            return "Use latest JAXB API and runtime for Jakarta EE 8";
        }

        public String getDescription() {
            return "Update Gradle build files to use the latest JAXB runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAXB run-time, in `compileOnly`+`testImplementation` configurations, to any project that has a transitive dependency on the JAXB API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return Preconditions.check((TreeVisitor)new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

                public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                    G.CompilationUnit g = cu;
                    if ("sun".equals(runtime)) {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new org.openrewrite.gradle.UpgradeDependencyVersion(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor());
                        }
                        g = (G.CompilationUnit)new ChangeDependency(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor().visit((Tree)g, (Object)ctx);
                    } else {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new org.openrewrite.gradle.UpgradeDependencyVersion(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor());
                        }
                        g = (G.CompilationUnit)new ChangeDependency(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor().visit((Tree)g, (Object)ctx);
                    }
                    this.maybeAddRuntimeDependency(g);
                    return g;
                }

                private void maybeAddRuntimeDependency(G.CompilationUnit g) {
                    Set<String> runtimeConfigurations;
                    Optional maybeGp = g.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return;
                    }
                    GradleProject gp = (GradleProject)maybeGp.get();
                    Set<String> apiConfigurations = this.getTransitiveDependencyConfiguration(gp, AddJaxbRuntime.JAKARTA_API_GROUP, AddJaxbRuntime.JAKARTA_API_ARTIFACT);
                    if (apiConfigurations.isEmpty()) {
                        return;
                    }
                    Set<String> set = runtimeConfigurations = "sun".equals(runtime) ? this.getTransitiveDependencyConfiguration(gp, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT) : this.getTransitiveDependencyConfiguration(gp, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT);
                    if (runtimeConfigurations.isEmpty()) {
                        if (gp.getConfiguration("compileOnly") != null) {
                            this.doAfterVisit((TreeVisitor)this.addDependency("compileOnly"));
                        }
                        if (gp.getConfiguration("testImplementation") != null) {
                            this.doAfterVisit((TreeVisitor)this.addDependency("testImplementation"));
                        }
                    } else {
                        for (String apiConfiguration : apiConfigurations) {
                            GradleDependencyConfiguration apiGdc = gp.getConfiguration(apiConfiguration);
                            List apiTransitives = gp.configurationsExtendingFrom(apiGdc, true);
                            for (String runtimeConfiguration : runtimeConfigurations) {
                                GradleDependencyConfiguration runtimeGdc = gp.getConfiguration(runtimeConfiguration);
                                List runtimeTransitives = gp.configurationsExtendingFrom(runtimeGdc, true);
                                if (!apiTransitives.stream().noneMatch(runtimeTransitives::contains)) continue;
                                this.doAfterVisit((TreeVisitor)this.addDependency(apiConfiguration));
                            }
                        }
                    }
                }

                private Set<String> getTransitiveDependencyConfiguration(GradleProject gp, String groupId, String artifactId) {
                    GradleDependencyConfiguration gdc;
                    HashSet<String> configurations = new HashSet<String>();
                    for (GradleDependencyConfiguration gdc2 : gp.getConfigurations()) {
                        if (gdc2.findRequestedDependency(groupId, artifactId) == null && gdc2.findResolvedDependency(groupId, artifactId) == null) continue;
                        configurations.add(gdc2.getName());
                    }
                    HashSet tmpConfigurations = new HashSet(configurations);
                    for (String tmpConfiguration : tmpConfigurations) {
                        gdc = gp.getConfiguration(tmpConfiguration);
                        for (GradleDependencyConfiguration transitive : gp.configurationsExtendingFrom(gdc, true)) {
                            configurations.remove(transitive.getName());
                        }
                    }
                    tmpConfigurations = new HashSet(configurations);
                    for (String configuration : tmpConfigurations) {
                        gdc = gp.getConfiguration(configuration);
                        for (GradleDependencyConfiguration extendsFrom : gdc.allExtendsFrom()) {
                            if (!configurations.contains(extendsFrom.getName())) continue;
                            configurations.remove(configuration);
                        }
                    }
                    return configurations;
                }

                private AddDependencyVisitor addDependency(String configuration) {
                    return "sun".equals(runtime) ? new AddDependencyVisitor(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, configuration, null, null, null, null) : new AddDependencyVisitor(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, configuration, null, null, null, null);
                }
            });
        }

        @ConstructorProperties(value={"runtime"})
        public AddJaxbRuntimeGradle(String runtime) {
            this.runtime = runtime;
        }

        public String getRuntime() {
            return this.runtime;
        }

        @NonNull
        public String toString() {
            return "AddJaxbRuntime.AddJaxbRuntimeGradle(runtime=" + this.getRuntime() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxbRuntimeGradle)) {
                return false;
            }
            AddJaxbRuntimeGradle other = (AddJaxbRuntimeGradle)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$runtime = this.getRuntime();
            String other$runtime = other.getRuntime();
            return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AddJaxbRuntimeGradle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
            return result;
        }
    }

    static final class AddJaxbRuntimeMaven
    extends Recipe {
        private final String runtime;

        public String getDisplayName() {
            return "Use latest JAXB API and runtime for Jakarta EE 8";
        }

        public String getDescription() {
            return "Update Maven build files to use the latest JAXB runtime from Jakarta EE 8 to maintain compatibility with Java version 11 or greater.  The recipe will add a JAXB run-time, in `provided` scope, to any project that has a transitive dependency on the JAXB API. **The resulting dependencies still use the `javax` namespace, despite the move to the Jakarta artifact**.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new MavenIsoVisitor<ExecutionContext>(){

                public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                    Xml.Document d = super.visitDocument(document, (Object)ctx);
                    if ("sun".equals(runtime)) {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new UpgradeDependencyVersion(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, null, null).getVisitor());
                        }
                        d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor().visit((Tree)d, (Object)ctx);
                        d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x").getVisitor().visit((Tree)d, (Object)ctx);
                    } else {
                        if (this.getAfterVisit().isEmpty()) {
                            this.doAfterVisit(new UpgradeDependencyVersion(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, null, null).getVisitor());
                        }
                        d = (Xml.Document)new ChangeDependencyGroupIdAndArtifactId(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null).getVisitor().visit((Tree)d, (Object)ctx);
                        d = (Xml.Document)new ChangeManagedDependencyGroupIdAndArtifactId(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x").getVisitor().visit((Tree)d, (Object)ctx);
                    }
                    if (d != document) {
                        return d;
                    }
                    return this.maybeAddRuntimeDependency(d, ctx);
                }

                private Xml.Document maybeAddRuntimeDependency(Xml.Document d, ExecutionContext ctx) {
                    Scope runtimeScope;
                    MavenResolutionResult mavenModel = this.getResolutionResult();
                    Scope apiScope = this.getTransitiveDependencyScope(mavenModel, AddJaxbRuntime.JAKARTA_API_GROUP, AddJaxbRuntime.JAKARTA_API_ARTIFACT);
                    Scope scope = runtimeScope = "sun".equals(runtime) ? this.getTransitiveDependencyScope(mavenModel, AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT) : this.getTransitiveDependencyScope(mavenModel, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT);
                    if (!(apiScope == null || runtimeScope != null && apiScope.isInClasspathOf(runtimeScope))) {
                        String resolvedScope = apiScope == Scope.Test ? "test" : "provided";
                        org.openrewrite.maven.AddDependencyVisitor addDependency = "sun".equals(runtime) ? new org.openrewrite.maven.AddDependencyVisitor(AddJaxbRuntime.SUN_JAXB_RUNTIME_GROUP, AddJaxbRuntime.SUN_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null) : new org.openrewrite.maven.AddDependencyVisitor(AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_GROUP, AddJaxbRuntime.GLASSFISH_JAXB_RUNTIME_ARTIFACT, "2.3.x", null, resolvedScope, null, null, null, null, null);
                        return (Xml.Document)addDependency.visit((Tree)d, (Object)ctx);
                    }
                    return d;
                }

                @Nullable
                private Scope getTransitiveDependencyScope(MavenResolutionResult mavenModel, String groupId, String artifactId) {
                    Scope maxScope = null;
                    block0: for (Map.Entry entry : mavenModel.getDependencies().entrySet()) {
                        for (ResolvedDependency dependency : (List)entry.getValue()) {
                            if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                            if (!Scope.Compile.equals((Object)(maxScope = Scope.maxPrecedence(maxScope, (Scope)((Scope)entry.getKey()))))) continue block0;
                            return maxScope;
                        }
                    }
                    return maxScope;
                }
            };
        }

        @ConstructorProperties(value={"runtime"})
        public AddJaxbRuntimeMaven(String runtime) {
            this.runtime = runtime;
        }

        public String getRuntime() {
            return this.runtime;
        }

        @NonNull
        public String toString() {
            return "AddJaxbRuntime.AddJaxbRuntimeMaven(runtime=" + this.getRuntime() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJaxbRuntimeMaven)) {
                return false;
            }
            AddJaxbRuntimeMaven other = (AddJaxbRuntimeMaven)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$runtime = this.getRuntime();
            String other$runtime = other.getRuntime();
            return !(this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AddJaxbRuntimeMaven;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
            return result;
        }
    }
}

