/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddMissingMethodImplementation
extends Recipe {
    @Option(displayName="Fully Qualified Class Name", description="A fully qualified class being implemented with missing method.", example="com.yourorg.FooBar")
    @NonNull
    private final String fullyQualifiedClassName;
    @Option(displayName="Method Pattern", description="A method pattern for matching required method definition.", example="*..* hello(..)")
    @NonNull
    private final String methodPattern;
    @Option(displayName="Method Template", description="Template of method to add", example="public String hello() { return \\\"Hello from #{}!\\\"; }")
    @NonNull
    private final String methodTemplateString;

    public String getDisplayName() {
        return "Adds missing method implementations";
    }

    public String getDescription() {
        return "Check for missing methods required by interfaces and adds them.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.fullyQualifiedClassName, Boolean.valueOf(true)), (TreeVisitor)new ClassImplementationVisitor());
    }

    @ConstructorProperties(value={"fullyQualifiedClassName", "methodPattern", "methodTemplateString"})
    public AddMissingMethodImplementation(@NonNull String fullyQualifiedClassName, @NonNull String methodPattern, @NonNull String methodTemplateString) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.methodPattern = methodPattern;
        this.methodTemplateString = methodTemplateString;
    }

    @NonNull
    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    @NonNull
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String getMethodTemplateString() {
        return this.methodTemplateString;
    }

    @NonNull
    public String toString() {
        return "AddMissingMethodImplementation(fullyQualifiedClassName=" + this.getFullyQualifiedClassName() + ", methodPattern=" + this.getMethodPattern() + ", methodTemplateString=" + this.getMethodTemplateString() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingMethodImplementation)) {
            return false;
        }
        AddMissingMethodImplementation other = (AddMissingMethodImplementation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedClassName = this.getFullyQualifiedClassName();
        String other$fullyQualifiedClassName = other.getFullyQualifiedClassName();
        if (this$fullyQualifiedClassName == null ? other$fullyQualifiedClassName != null : !this$fullyQualifiedClassName.equals(other$fullyQualifiedClassName)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$methodTemplateString = this.getMethodTemplateString();
        String other$methodTemplateString = other.getMethodTemplateString();
        return !(this$methodTemplateString == null ? other$methodTemplateString != null : !this$methodTemplateString.equals(other$methodTemplateString));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingMethodImplementation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedClassName = this.getFullyQualifiedClassName();
        result = result * 59 + ($fullyQualifiedClassName == null ? 43 : $fullyQualifiedClassName.hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $methodTemplateString = this.getMethodTemplateString();
        result = result * 59 + ($methodTemplateString == null ? 43 : $methodTemplateString.hashCode());
        return result;
    }

    public class ClassImplementationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaTemplate methodTemplate;
        private final MethodMatcher methodMatcher;

        public ClassImplementationVisitor() {
            this.methodTemplate = JavaTemplate.builder((String)AddMissingMethodImplementation.this.methodTemplateString).build();
            this.methodMatcher = new MethodMatcher(AddMissingMethodImplementation.this.methodPattern, true);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cs, ExecutionContext ctx) {
            J.ClassDeclaration classDecl = super.visitClassDeclaration(cs, (Object)ctx);
            if (classDecl.hasModifier(J.Modifier.Type.Abstract) || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                return classDecl;
            }
            if (!TypeUtils.isAssignableTo((String)AddMissingMethodImplementation.this.fullyQualifiedClassName, (JavaType)classDecl.getType())) {
                return classDecl;
            }
            if (classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).anyMatch(methodDeclaration -> this.methodMatcher.matches(methodDeclaration, classDecl))) {
                return classDecl;
            }
            return classDecl.withBody((J.Block)this.methodTemplate.apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().lastStatement(), new Object[0]));
        }
    }
}

