/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class AddDefaultConstructorToEntityClass
extends Recipe {
    public String getDisplayName() {
        return "`@Entity` objects with constructors must also have a default constructor";
    }

    public String getDescription() {
        return "When a Java Persistence API (JPA) entity class has a constructor with arguments, the class must also have a default, no-argument constructor. The OpenJPA implementation automatically generates the no-argument constructor, but the EclipseLink implementation does not.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), new UsesType("javax.persistence.MappedSuperclass", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (FindAnnotations.find((J)classDecl, (String)"javax.persistence.Entity").isEmpty() && FindAnnotations.find((J)classDecl, (String)"javax.persistence.MappedSuperclass").isEmpty()) {
                    return classDecl;
                }
                if (classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).filter(J.MethodDeclaration::isConstructor).anyMatch(constructor -> constructor.getParameters().get(0) instanceof J.Empty)) {
                    return classDecl;
                }
                return classDecl.withBody((J.Block)JavaTemplate.builder((String)"public #{}(){}").contextSensitive().build().apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{classDecl.getSimpleName()}));
            }
        });
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDefaultConstructorToEntityClass)) {
            return false;
        }
        AddDefaultConstructorToEntityClass other = (AddDefaultConstructorToEntityClass)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDefaultConstructorToEntityClass;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

