/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveTemporalAnnotation
extends Recipe {
    public String getDisplayName() {
        return "Remove the `@Temporal` annotation for some `java.sql` attributes";
    }

    public String getDescription() {
        return "OpenJPA persists the fields of attributes of type `java.sql.Date`, `java.sql.Time`, or `java.sql.Timestamp` that have a `javax.persistence.Temporal` annotation, whereas EclipseLink throws an exception. Remove the `@Temporal` annotation so the behavior in EclipseLink will match the behavior in OpenJPA.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern temporalPattern = Pattern.compile(".*TemporalType\\.(TIMESTAMP|DATE|TIME)");
        String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
        String JAVA_SQL_TIME = "java.sql.Time";
        String JAVA_SQL_DATE = "java.sql.Date";
        final Set javaSqlDateTimeTypes = Stream.of("java.sql.Timestamp", "java.sql.Time", "java.sql.Date").collect(Collectors.toSet());
        final Map<String, String> doNotRemove = Stream.of({"DATE", "java.sql.Timestamp"}, {"TIME", "java.sql.Timestamp"}, {"TIMESTAMP", "java.sql.Date"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Temporal", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.sql.Date", Boolean.valueOf(true)), new UsesType("java.sql.Time", Boolean.valueOf(true)), new UsesType("java.sql.Timestamp", Boolean.valueOf(true))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                String varClass = multiVariable.getType().toString();
                Set temporalAnnos = FindAnnotations.find((J)multiVariable, (String)"javax.persistence.Temporal");
                if (temporalAnnos.isEmpty() || !javaSqlDateTimeTypes.contains(varClass)) {
                    return multiVariable;
                }
                J.Annotation temporal = (J.Annotation)temporalAnnos.iterator().next();
                String temporalArg = ((Expression)temporal.getArguments().iterator().next()).toString();
                Matcher temporalMatch = temporalPattern.matcher(temporalArg);
                if (!temporalMatch.find()) {
                    return multiVariable;
                }
                String temporalType = temporalMatch.group(1);
                if (((String)doNotRemove.get(temporalType)).equals(varClass)) {
                    return multiVariable;
                }
                return (J.VariableDeclarations)new RemoveAnnotation("javax.persistence.Temporal").getVisitor().visit((Tree)multiVariable, (Object)ctx);
            }
        });
    }

    @NonNull
    public String toString() {
        return "RemoveTemporalAnnotation()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveTemporalAnnotation)) {
            return false;
        }
        RemoveTemporalAnnotation other = (RemoveTemporalAnnotation)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveTemporalAnnotation;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

