/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.staticanalysis.ModifierOrder;

public final class MXBeanRule
extends Recipe {
    public String getDisplayName() {
        return "MBean and MXBean interfaces must be public";
    }

    public String getDescription() {
        return "Sets visibility of MBean and MXBean interfaces to public.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new JavaVisitor<ExecutionContext>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!classDecl.hasModifier(J.Modifier.Type.Public) && classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                    return (J)SearchResult.found((Tree)classDecl, (String)"Not yet public interface");
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }, Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.management.MXBean", Boolean.valueOf(true)), new JavaVisitor<ExecutionContext>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                String className = classDecl.getName().getSimpleName();
                if (className.endsWith("MXBean") || className.endsWith("MBean")) {
                    return (J)SearchResult.found((Tree)classDecl, (String)"Matching class name");
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }})}), (TreeVisitor)new ClassImplementationVisitor());
    }

    @NonNull
    public String toString() {
        return "MXBeanRule()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MXBeanRule)) {
            return false;
        }
        MXBeanRule other = (MXBeanRule)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MXBeanRule;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ClassImplementationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher MX_BEAN = new AnnotationMatcher("@javax.management.MXBean");
        private static final AnnotationMatcher MX_BEAN_VALUE_TRUE = new AnnotationMatcher("@javax.management.MXBean(value=true)");

        private ClassImplementationVisitor() {
        }

        private boolean shouldUpdate(J.ClassDeclaration classDecl) {
            List leadingAnnotations = classDecl.getLeadingAnnotations();
            Optional<J.Annotation> firstAnnotation = leadingAnnotations.stream().filter(arg_0 -> ((AnnotationMatcher)MX_BEAN).matches(arg_0)).findFirst();
            if (firstAnnotation.isPresent()) {
                List arguments = firstAnnotation.get().getArguments();
                return arguments == null || arguments.isEmpty() || MX_BEAN_VALUE_TRUE.matches(firstAnnotation.get());
            }
            String className = classDecl.getName().getSimpleName();
            return className.endsWith("MXBean") || className.endsWith("MBean");
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
            if (!this.shouldUpdate(cd)) {
                return cd;
            }
            ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>(cd.getModifiers());
            modifiers.removeIf(modifier -> modifier.getType() == J.Modifier.Type.Private || modifier.getType() == J.Modifier.Type.Protected || modifier.getType() == J.Modifier.Type.Abstract);
            modifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Public, Collections.emptyList()));
            return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)cd.withModifiers(ModifierOrder.sortModifiers(modifiers)), ctx);
        }
    }
}

