/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.maven;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddProperty;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpdateMavenProjectPropertyJavaVersion
extends Recipe {
    private static final List<String> JAVA_VERSION_PROPERTIES = Arrays.asList("java.version", "jdk.version", "javaVersion", "jdkVersion", "maven.compiler.source", "maven.compiler.target", "maven.compiler.release", "release.version");
    private static final List<XPathMatcher> JAVA_VERSION_XPATH_MATCHERS = JAVA_VERSION_PROPERTIES.stream().map(property -> "/project/properties/" + property).map(XPathMatcher::new).collect(Collectors.toList());
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;

    public String getDisplayName() {
        return "Update Maven Java project properties";
    }

    public String getDescription() {
        return "The Java version is determined by several project properties, including:\n\n * `java.version`\n * `jdk.version`\n * `javaVersion`\n * `jdkVersion`\n * `maven.compiler.source`\n * `maven.compiler.target`\n * `maven.compiler.release`\n * `release.version`\n\n These project properties are not added if they are not currently set, but only updated in place.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final Set<String> propertiesExplicitlyReferenced = new HashSet<String>();

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                Optional pathToLocalParent = d.getRoot().getChild("parent").flatMap(parent -> parent.getChild("relativePath")).flatMap(Xml.Tag::getValue);
                if (pathToLocalParent.isPresent()) {
                    return d;
                }
                Map currentProperties = this.getResolutionResult().getPom().getRequested().getProperties();
                for (String property : JAVA_VERSION_PROPERTIES) {
                    if (currentProperties.containsKey(property) || !this.propertiesExplicitlyReferenced.contains(property)) continue;
                    d = (Xml.Document)new AddProperty(property, String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version), null, Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)d, (Object)ctx);
                }
                return d;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                tag = super.visitTag(tag, (Object)ctx);
                Optional<String> s = tag.getValue().map(it -> it.replace("${", "").replace("}", "").trim()).filter(JAVA_VERSION_PROPERTIES::contains);
                if (s.isPresent()) {
                    this.propertiesExplicitlyReferenced.add(s.get());
                } else if (JAVA_VERSION_XPATH_MATCHERS.stream().anyMatch(matcher -> matcher.matches(this.getCursor()))) {
                    Optional maybeVersion = tag.getValue().flatMap(value -> {
                        try {
                            return Optional.of(Float.valueOf(Float.parseFloat(value)));
                        }
                        catch (NumberFormatException e) {
                            return Optional.empty();
                        }
                    });
                    if (!maybeVersion.isPresent()) {
                        return tag;
                    }
                    float currentVersion = ((Float)maybeVersion.get()).floatValue();
                    if (currentVersion >= (float)UpdateMavenProjectPropertyJavaVersion.this.version.intValue()) {
                        return tag;
                    }
                    return tag.withValue(String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version));
                }
                return tag;
            }
        };
    }

    @ConstructorProperties(value={"version"})
    public UpdateMavenProjectPropertyJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpdateMavenProjectPropertyJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMavenProjectPropertyJavaVersion)) {
            return false;
        }
        UpdateMavenProjectPropertyJavaVersion other = (UpdateMavenProjectPropertyJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMavenProjectPropertyJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

