/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NonNullApi
public class UseStringIsEmptyRecipe
extends Recipe {
    public String getDisplayName() {
        return "Replace `0 < s.length()` with `!s.isEmpty()`";
    }

    public String getDescription() {
        return "Replace `0 < s.length()` and `s.length() != 0` with `!s.isEmpty()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            final JavaTemplate beforeGreaterThan = JavaTemplate.builder((String)"#{s:any(java.lang.String)}.length() > 0").build();
            final JavaTemplate beforeLessThan = JavaTemplate.builder((String)"0 < #{s:any(java.lang.String)}.length()").build();
            final JavaTemplate beforeNotZero = JavaTemplate.builder((String)"0 != #{s:any(java.lang.String)}.length()").build();
            final JavaTemplate beforeNotZeroEither = JavaTemplate.builder((String)"#{s:any(java.lang.String)}.length() != 0").build();
            final JavaTemplate after = JavaTemplate.builder((String)"!#{s:any(java.lang.String)}.isEmpty()").build();

            public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.beforeGreaterThan.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                }
                matcher = this.beforeLessThan.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                }
                matcher = this.beforeNotZero.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                }
                matcher = this.beforeNotZeroEither.matcher(this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                }
                return super.visitBinary(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String length(..)"), (TreeVisitor)javaVisitor);
    }
}

