/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateClassNewInstanceToGetDeclaredConstructorNewInstance
extends Recipe {
    private static final MethodMatcher NEW_INSTANCE_MATCHER = new MethodMatcher("java.lang.Class newInstance()");

    public String getDisplayName() {
        return "Use `Class#getDeclaredConstructor().newInstance()`";
    }

    public String getDescription() {
        return "Use `Class#getDeclaredConstructor().newInstance()` instead of the deprecated `Class#newInstance()` in Java 9 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("deprecated");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod("java.lang.Class newInstance()")}), (TreeVisitor)new NewInstanceToDeclaredConstructorVisitor());
    }

    private static class NewInstanceToDeclaredConstructorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final ChangeMethodName TO_DECLARED_CONS_NEW_INSTANCE = new ChangeMethodName("java.lang.Class newInstance()", "getDeclaredConstructor().newInstance", null, Boolean.valueOf(false));
        private final JavaType exType = JavaType.buildType((String)"java.lang.Exception");
        private final JavaType thType = JavaType.buildType((String)"java.lang.Throwable");

        private NewInstanceToDeclaredConstructorVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (NEW_INSTANCE_MATCHER.matches((MethodCall)mi)) {
                J.Try tri = (J.Try)this.getCursor().firstEnclosing(J.Try.class);
                J.Try.Catch catch_ = (J.Try.Catch)this.getCursor().firstEnclosing(J.Try.Catch.class);
                J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (catch_ == null && tri != null && tri.getCatches().stream().anyMatch(c -> this.isExceptionType(c.getParameter().getType())) || md != null && md.getThrows() != null && md.getThrows().stream().anyMatch(nt -> this.isExceptionType(nt.getType()))) {
                    mi = (J.MethodInvocation)TO_DECLARED_CONS_NEW_INSTANCE.getVisitor().visitNonNull((Tree)mi, (Object)ctx);
                }
            }
            return mi;
        }

        private boolean isExceptionType(@Nullable JavaType type) {
            return TypeUtils.isOfType((JavaType)type, (JavaType)this.exType) || TypeUtils.isOfType((JavaType)type, (JavaType)this.thType);
        }
    }
}

