/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.staticanalysis.RemoveMethodCallVisitor;

public final class RemoveMethodInvocation
extends Recipe {
    @Option(displayName="Method Pattern", description="A method pattern for matching required method definition.", example="*..* hello(..)")
    private final String methodPattern;

    public String getDisplayName() {
        return "Remove methods calls";
    }

    public String getDescription() {
        return "Checks for a method patterns and removes the method call from the class.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveMethodCallVisitor(new MethodMatcher(this.methodPattern), (n, it) -> true);
    }

    @ConstructorProperties(value={"methodPattern"})
    @Generated
    public RemoveMethodInvocation(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveMethodInvocation(methodPattern=" + this.getMethodPattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveMethodInvocation)) {
            return false;
        }
        RemoveMethodInvocation other = (RemoveMethodInvocation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveMethodInvocation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

