/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class NoGuavaRefasterRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster style Guava to Java migration recipes";
    }

    public String getDescription() {
        return "Recipes that migrate from Guava to Java, using Refaster style templates for cases beyond what declarative recipes can cover.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new PreconditionsCheckNotNullToObjectsRequireNonNullRecipe(), new PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullRecipe(), new StringValueOfStringRecipe()});
    }

    @NullMarked
    public static class PreconditionsCheckNotNullToObjectsRequireNonNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`Preconditions.checkNotNull` to `Objects.requireNonNull`";
        }

        public String getDescription() {
            return "Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(java.lang.Object)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Preconditions", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`Preconditions.checkNotNull` with message to `Objects.requireNonNull`";
        }

        public String getDescription() {
            return "Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(java.lang.Object)}, String.valueOf(#{message:any(java.lang.Object)}))").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Preconditions", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringValueOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`String.valueof(String)` to `String`";
        }

        public String getDescription() {
            return "Migrate from `String.valueof(String)` to `String`, mainly as a cleanup after other recipes.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"String.valueOf(#{string:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"(#{string:any(java.lang.String)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String valueOf(..)", true), (TreeVisitor)javaVisitor);
        }
    }
}

