/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.javax.AnnotateTypesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class AddScopeToInjectedClass
extends ScanningRecipe<Set<String>> {
    private static final String JAVAX_INJECT_INJECT = "javax.inject.Inject";
    private static final String JAVAX_ENTERPRISE_CONTEXT_DEPENDENT = "javax.enterprise.context.Dependent";

    public String getDisplayName() {
        return "Add scope annotation to injected classes";
    }

    public String getDescription() {
        return "Finds member variables annotated with `@Inject' and applies `@Dependent` scope annotation to the variable's type.";
    }

    public Set<String> getInitialValue(ExecutionContext ctx) {
        return new HashSet<String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<String> injectedTypes) {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher matcher = new AnnotationMatcher("@javax.inject.Inject");

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                for (JavaType.Variable variable : cd.getType().getMembers()) {
                    if (!this.variableTypeRequiresScope(variable)) continue;
                    injectedTypes.add(((JavaType.FullyQualified)variable.getType()).getFullyQualifiedName());
                }
                return cd;
            }

            private boolean variableTypeRequiresScope(// Could not load outer class - annotation placement on inner may be incorrect
             @Nullable JavaType.Variable memberVariable) {
                if (memberVariable == null) {
                    return false;
                }
                for (JavaType.FullyQualified fullYQualifiedAnnotation : memberVariable.getAnnotations()) {
                    if (!this.matcher.matchesAnnotationOrMetaAnnotation(fullYQualifiedAnnotation)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<String> injectedTypes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
                J.CompilationUnit cu = super.visitCompilationUnit(compilationUnit, (Object)ctx);
                for (J.ClassDeclaration aClass : cu.getClasses()) {
                    if (aClass.getType() == null || !injectedTypes.contains(aClass.getType().getFullyQualifiedName())) continue;
                    return (J.CompilationUnit)new AnnotateTypesVisitor(AddScopeToInjectedClass.JAVAX_ENTERPRISE_CONTEXT_DEPENDENT).visit((Tree)cu, injectedTypes, this.getCursor().getParent());
                }
                return cu;
            }
        };
    }
}

