/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda.templates;

import java.util.function.Function;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class MethodTemplate {
    private final MethodMatcher matcher;
    private final JavaTemplate template;
    private final Function<MethodCall, Expression[]> templateArgsFunc;

    public MethodTemplate(MethodMatcher matcher, JavaTemplate template) {
        this(matcher, template, m -> {
            Expression select;
            Expression expression = select = MethodTemplate.isInstanceCall(m) ? ((J.MethodInvocation)m).getSelect() : null;
            if (m.getArguments().isEmpty() || m.getArguments().get(0) instanceof J.Empty) {
                Expression[] expressionArray;
                if (select != null) {
                    Expression[] expressionArray2 = new Expression[1];
                    expressionArray = expressionArray2;
                    expressionArray2[0] = select;
                } else {
                    expressionArray = new Expression[]{};
                }
                return expressionArray;
            }
            Expression[] args = m.getArguments().toArray(new Expression[0]);
            if (select != null) {
                Expression[] newArgs = new Expression[args.length + 1];
                newArgs[0] = select;
                System.arraycopy(args, 0, newArgs, 1, args.length);
                return newArgs;
            }
            return args;
        });
    }

    public MethodTemplate(MethodMatcher matcher, JavaTemplate template, Function<MethodCall, Expression[]> templateArgsFunc) {
        this.matcher = matcher;
        this.template = template;
        this.templateArgsFunc = templateArgsFunc;
    }

    private static boolean isInstanceCall(MethodCall m) {
        if (!(m instanceof J.MethodInvocation)) {
            return false;
        }
        J.MethodInvocation mi = (J.MethodInvocation)m;
        if (mi.getSelect() instanceof J.FieldAccess) {
            return ((J.FieldAccess)mi.getSelect()).getName().getFieldType() != null;
        }
        if (mi.getSelect() instanceof J.Identifier) {
            return ((J.Identifier)mi.getSelect()).getFieldType() != null;
        }
        return true;
    }

    @Generated
    public MethodMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public JavaTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public Function<MethodCall, Expression[]> getTemplateArgsFunc() {
        return this.templateArgsFunc;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodTemplate)) {
            return false;
        }
        MethodTemplate other = (MethodTemplate)o;
        MethodMatcher this$matcher = this.getMatcher();
        MethodMatcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        JavaTemplate this$template = this.getTemplate();
        JavaTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Function<MethodCall, Expression[]> this$templateArgsFunc = this.getTemplateArgsFunc();
        Function<MethodCall, Expression[]> other$templateArgsFunc = other.getTemplateArgsFunc();
        return !(this$templateArgsFunc == null ? other$templateArgsFunc != null : !this$templateArgsFunc.equals(other$templateArgsFunc));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        JavaTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Function<MethodCall, Expression[]> $templateArgsFunc = this.getTemplateArgsFunc();
        result = result * 59 + ($templateArgsFunc == null ? 43 : $templateArgsFunc.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MethodTemplate(matcher=" + this.getMatcher() + ", template=" + this.getTemplate() + ", templateArgsFunc=" + this.getTemplateArgsFunc() + ")";
    }
}

