/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.net.URI;
import java.net.URL;
import org.openrewrite.java.template.RecipeDescriptor;

public class URLConstructorsToURI {

    @RecipeDescriptor(name="Convert `new URL(String, String, int, String)` to `new URI(...).toURL()`", description="Converts `new URL(String, String, int, String)` constructors to `new URI(...).toURL()`.")
    public static class URLFourArgumentConstructor {
        URL urlConstructor(String protocol, String host, int port, String file) throws Exception {
            return new URL(protocol, host, port, file);
        }

        URL newUriToUrl(String protocol, String host, int port, String file) throws Exception {
            return new URI(protocol, null, host, port, file, null, null).toURL();
        }
    }

    @RecipeDescriptor(name="Convert `new URL(String, String, String)` to `new URI(...).toURL()`", description="Converts `new URL(String, String, String)` constructors to `new URI(...).toURL()`.")
    public static class URLThreeArgumentConstructor {
        URL urlConstructor(String protocol, String host, String file) throws Exception {
            return new URL(protocol, host, file);
        }

        URL newUriToUrl(String protocol, String host, String file) throws Exception {
            return new URI(protocol, null, host, -1, file, null, null).toURL();
        }
    }

    @RecipeDescriptor(name="Convert `new URL(String)` to `URI.create(String).toURL()`", description="Converts `new URL(String)` constructors to `URI.create(String).toURL()`.")
    public static class URLSingleArgumentConstructor {
        URL urlConstructor(String spec) throws Exception {
            return new URL(spec);
        }

        URL uriCreateToURL(String spec) throws Exception {
            return URI.create(spec).toURL();
        }
    }
}

