/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda.templates;

import java.util.HashMap;
import java.util.Map;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class VarTemplates {
    private static Map<String, String> JodaToJavaTimeType = new HashMap<String, String>(){
        {
            this.put("org.joda.time.DateTime", "java.time.ZonedDateTime");
            this.put("org.joda.time.format.DateTimeFormatter", "java.time.format.DateTimeFormatter");
            this.put("org.joda.time.LocalDate", "java.time.LocalDate");
            this.put("org.joda.time.LocalTime", "java.time.LocalTime");
            this.put("org.joda.time.DateTimeZone", "java.time.ZoneId");
            this.put("org.joda.time.Duration", "java.time.Duration");
        }
    };

    public static JavaTemplate getTemplate(J.VariableDeclarations variable) {
        String varName;
        JavaType.Class type = (JavaType.Class)variable.getTypeExpression().getType();
        String typeName = JodaToJavaTimeType.get(type.getFullyQualifiedName());
        StringBuilder template = new StringBuilder();
        try {
            varName = Class.forName(typeName).getSimpleName();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown type " + typeName);
        }
        template.append(varName);
        template.append(" ");
        for (int i = 0; i < variable.getVariables().size(); ++i) {
            if (i > 0) {
                template.append(", ");
            }
            template.append("#{}");
            if (((J.VariableDeclarations.NamedVariable)variable.getVariables().get(i)).getInitializer() == null) continue;
            template.append(" = #{any(");
            template.append(typeName);
            template.append(")}");
        }
        return JavaTemplate.builder((String)template.toString()).imports(new String[]{typeName}).build();
    }

    public static JavaTemplate getTemplate(J.Assignment assignment) {
        JavaType.Class type = (JavaType.Class)assignment.getAssignment().getType();
        JavaType.Class varType = (JavaType.Class)assignment.getVariable().getType();
        String typeName = JodaToJavaTimeType.get(type.getFullyQualifiedName());
        String varTypeName = JodaToJavaTimeType.get(varType.getFullyQualifiedName());
        String template = "#{any(" + varTypeName + ")} = #{any(" + typeName + ")}";
        return JavaTemplate.builder((String)template).build();
    }

    public static Object[] getTemplateArgs(J.VariableDeclarations variable) {
        Object[] args = new Object[variable.getVariables().size() * 2];
        int i = 0;
        for (J.VariableDeclarations.NamedVariable var : variable.getVariables()) {
            args[i++] = var.getSimpleName();
            if (var.getInitializer() == null) continue;
            args[i++] = var.getInitializer();
        }
        Object[] args2 = new Object[i];
        System.arraycopy(args, 0, args2, 0, i);
        return args2;
    }
}

