/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class StringFormatted
extends Recipe {
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(String, ..)");

    public String getDisplayName() {
        return "Prefer `String#formatted(Object...)`";
    }

    public String getDescription() {
        return "Prefer `String#formatted(Object...)` over `String#format(String, Object...)` in Java 17 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesMethod(STRING_FORMAT)}), (TreeVisitor)new StringFormattedVisitor());
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    private static class StringFormattedVisitor
    extends JavaVisitor<ExecutionContext> {
        private StringFormattedVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            if (!STRING_FORMAT.matches((MethodCall)method) || method.getMethodType() == null) {
                return method;
            }
            List arguments = method.getArguments();
            boolean wrapperNotNeeded = StringFormattedVisitor.wrapperNotNeeded((Expression)arguments.get(0));
            this.maybeRemoveImport("java.lang.String.format");
            J.MethodInvocation mi = method.withName(method.getName().withSimpleName("formatted"));
            Optional<JavaType.Method> formatted = method.getMethodType().getDeclaringType().getMethods().stream().filter(m -> m.getName().equals("formatted")).findAny();
            mi = mi.withMethodType((JavaType.Method)formatted.orElse(null));
            if (mi.getName().getType() != null) {
                mi = mi.withName(mi.getName().withType((JavaType)mi.getMethodType()));
            }
            J.Parentheses select = wrapperNotNeeded ? (Expression)arguments.get(0) : new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)((Expression)arguments.get(0))));
            mi = mi.withSelect((Expression)select);
            mi = mi.withArguments(arguments.subList(1, arguments.size()));
            return this.maybeAutoFormat((J)method, (J)mi, ctx);
        }

        private static boolean wrapperNotNeeded(Expression expression) {
            return expression instanceof J.Identifier || expression instanceof J.Literal || expression instanceof J.MethodInvocation || expression instanceof J.FieldAccess;
        }
    }
}

