/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public class ThreadStopUnsupported
extends Recipe {
    private static final MethodMatcher THREAD_STOP_MATCHER = new MethodMatcher("java.lang.Thread stop()");

    public String getDisplayName() {
        return "Replace `Thread.stop()` with `throw new UnsupportedOperationException()`";
    }

    public String getDescription() {
        return "`Thread.stop()` always throws a `new UnsupportedOperationException` in Java 21+. This recipe makes that explicit, as the migration is more complicated.See https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/doc-files/threadPrimitiveDeprecation.html .";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J j = super.visitMethodInvocation(method, (Object)executionContext);
                if (THREAD_STOP_MATCHER.matches((MethodCall)method)) {
                    if (this.usesJava21(executionContext)) {
                        JavaTemplate template = JavaTemplate.builder((String)"throw new UnsupportedOperationException()").contextSensitive().build();
                        j = template.apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                    }
                    if (j.getComments().isEmpty()) {
                        j = this.getWithComment(j);
                    }
                }
                return j;
            }

            private boolean usesJava21(ExecutionContext executionContext) {
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                return javaSourceFile != null && new UsesJavaVersion(21).visit((Tree)javaSourceFile, (Object)executionContext) != javaSourceFile;
            }

            private J getWithComment(J j) {
                String prefixWhitespace = j.getPrefix().getWhitespace();
                String commentText = prefixWhitespace + " * `Thread.stop()` always throws a `new UnsupportedOperationException()` in Java 21+." + prefixWhitespace + " * For detailed migration instructions see the migration guide available at" + prefixWhitespace + " * https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/doc-files/threadPrimitiveDeprecation.html" + prefixWhitespace + " ";
                return j.withComments(Collections.singletonList(new TextComment(true, commentText, prefixWhitespace, Markers.EMPTY)));
            }
        };
    }
}

