/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public class CastArraysAsListToList
extends Recipe {
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", false);
    private static final MethodMatcher LIST_TO_ARRAY = new MethodMatcher("java.util.List toArray()", true);

    public String getDisplayName() {
        return "Remove explicit casts on `Arrays.asList(..).toArray()`";
    }

    public String getDescription() {
        return "Convert code like `(Integer[]) Arrays.asList(1, 2, 3).toArray()` to `Arrays.asList(1, 2, 3).toArray(new Integer[0])`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ARRAYS_AS_LIST), new UsesMethod(LIST_TO_ARRAY)}), (TreeVisitor)new CastArraysAsListToListVisitor());
    }

    private static class CastArraysAsListToListVisitor
    extends JavaVisitor<ExecutionContext> {
        private CastArraysAsListToListVisitor() {
        }

        public J visitTypeCast(J.TypeCast typeCast, ExecutionContext executionContext) {
            boolean matches;
            J j = super.visitTypeCast(typeCast, (Object)executionContext);
            if (!(j instanceof J.TypeCast) || !(((J.TypeCast)j).getType() instanceof JavaType.Array)) {
                return j;
            }
            typeCast = (J.TypeCast)j;
            JavaType elementType = ((JavaType.Array)typeCast.getType()).getElemType();
            while (elementType instanceof JavaType.Array) {
                elementType = ((JavaType.Array)elementType).getElemType();
            }
            boolean bl = matches = (elementType instanceof JavaType.Class || elementType instanceof JavaType.Parameterized) && ((JavaType.FullyQualified)elementType).getOwningClass() == null && LIST_TO_ARRAY.matches(typeCast.getExpression()) && typeCast.getExpression() instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches(((J.MethodInvocation)typeCast.getExpression()).getSelect());
            if (!matches) {
                return typeCast;
            }
            String fullyQualifiedName = ((JavaType.FullyQualified)elementType).getFullyQualifiedName();
            J.ArrayType castType = (J.ArrayType)typeCast.getClazz().getTree();
            if (fullyQualifiedName.equals("java.lang.Object") && !(castType.getElementType() instanceof J.ArrayType)) {
                return typeCast;
            }
            StringBuilder newArrayString = new StringBuilder();
            String className = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
            newArrayString.append(className);
            newArrayString.append("[0]");
            TypeTree temp = castType.getElementType();
            while (temp instanceof J.ArrayType) {
                newArrayString.append("[]");
                temp = ((J.ArrayType)temp).getElementType();
            }
            JavaTemplate t = JavaTemplate.builder((String)("#{any(java.util.List)}.toArray(new " + newArrayString + ")")).imports(new String[]{fullyQualifiedName}).build();
            return t.apply(this.updateCursor((Tree)typeCast), typeCast.getCoordinates().replace(), new Object[]{((J.MethodInvocation)typeCast.getExpression()).getSelect()});
        }
    }
}

