/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaCreateTempDir
extends Recipe {
    public String getDisplayName() {
        return "Prefer `Files#createTempDirectory()`";
    }

    public String getDescription() {
        return "Replaces Guava `Files#createTempDir()` with Java `Files#createTempDirectory(..)`. Transformations are limited to scopes throwing or catching `java.io.IOException`.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-4738", "guava"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.io.Files createTempDir()"), (TreeVisitor)new NoGuavaTempDirVisitor());
    }

    private static class NoGuavaTempDirVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher guavaCreateTempDirMatcher = new MethodMatcher("com.google.common.io.Files createTempDir()");

        private NoGuavaTempDirVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeAddImport("java.nio.file.Files");
            this.maybeAddImport("java.io.IOException");
            this.maybeAddImport("java.io.File");
            this.maybeRemoveImport("com.google.common.io.Files");
            return c;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (guavaCreateTempDirMatcher.matches((MethodCall)mi)) {
                J.Try tr;
                Cursor parent = this.getCursor().dropParentUntil(j -> j instanceof J.MethodDeclaration || j instanceof J.Try || j instanceof J.ClassDeclaration);
                J parentValue = (J)parent.getValue();
                if (parentValue instanceof J.MethodDeclaration) {
                    J.MethodDeclaration md = (J.MethodDeclaration)parentValue;
                    if (md.getThrows() != null && md.getThrows().stream().anyMatch(n -> this.isIOExceptionOrException(TypeUtils.asFullyQualified((JavaType)n.getType())))) {
                        mi = this.toFilesCreateTempDir(mi);
                    }
                } else if (parentValue instanceof J.Try && (tr = (J.Try)parentValue).getCatches().stream().anyMatch(n -> this.isIOExceptionOrException(TypeUtils.asFullyQualified((JavaType)((J.VariableDeclarations)n.getParameter().getTree()).getType())))) {
                    mi = this.toFilesCreateTempDir(mi);
                }
            }
            return mi;
        }

        private boolean isIOExceptionOrException(@Nullable JavaType.FullyQualified fqCatch) {
            return fqCatch != null && ("java.io.IOException".matches(fqCatch.getFullyQualifiedName()) || "java.lang.Exception".matches(fqCatch.getFullyQualifiedName()));
        }

        private J.MethodInvocation toFilesCreateTempDir(J.MethodInvocation methodInvocation) {
            return (J.MethodInvocation)JavaTemplate.builder((String)"Files.createTempDirectory(null).toFile()").imports(new String[]{"java.nio.file.Files", "java.io.File"}).build().apply(this.updateCursor((Tree)methodInvocation), methodInvocation.getCoordinates().replace(), new Object[0]);
        }
    }
}

