/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;

public final class NullCheck
implements Trait<J.If> {
    private final Cursor cursor;
    private final Expression nullCheckedParameter;

    public Statement whenNull() {
        return ((J.If)this.getTree()).getThenPart();
    }

    public @Nullable Statement whenNotNull() {
        J.If.Else else_ = ((J.If)this.getTree()).getElsePart();
        return else_ == null ? null : else_.getBody();
    }

    public boolean returns() {
        Statement statement = this.whenNull();
        if (statement instanceof J.Block) {
            for (Statement s : ((J.Block)statement).getStatements()) {
                if (!(s instanceof J.Return)) continue;
                return true;
            }
            return false;
        }
        return statement instanceof J.Return;
    }

    public boolean couldModifyNullCheckedValue() {
        Statement statement = this.whenNull();
        if (statement instanceof J.Block || statement instanceof Expression || statement instanceof J.Throw) {
            return NullCheck.couldModifyNullCheckedValue((J)statement, this.nullCheckedParameter);
        }
        return true;
    }

    private static boolean couldModifyNullCheckedValue(J expression, final Expression nullChecked) {
        if (nullChecked instanceof J.FieldAccess && NullCheck.couldModifyNullCheckedValue(expression, ((J.FieldAccess)nullChecked).getTarget())) {
            return true;
        }
        if (nullChecked instanceof J.MethodInvocation && ((J.MethodInvocation)nullChecked).getSelect() != null && NullCheck.couldModifyNullCheckedValue(expression, ((J.MethodInvocation)nullChecked).getSelect())) {
            return true;
        }
        return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){
            private final boolean isCertainlyImmutable;
            {
                this.isCertainlyImmutable = nullChecked.getType() != null && JavaType.Primitive.fromClassName((String)nullChecked.getType().toString()) != null;
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, AtomicBoolean couldModifyValue) {
                J.Identifier id = super.visitIdentifier(identifier, (Object)couldModifyValue);
                if (!this.isCertainlyImmutable && SemanticallyEqual.areEqual((J)id, (J)nullChecked)) {
                    couldModifyValue.set(true);
                }
                return id;
            }

            public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean couldModifyValue) {
                J.Assignment as = super.visitAssignment(assignment, (Object)couldModifyValue);
                if (SemanticallyEqual.areEqual((J)as.getVariable(), (J)nullChecked)) {
                    couldModifyValue.set(true);
                }
                return as;
            }

            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, AtomicBoolean couldModifyValue) {
                J.FieldAccess fa = super.visitFieldAccess(fieldAccess, (Object)couldModifyValue);
                if (SemanticallyEqual.areEqual((J)fa, (J)nullChecked) || SemanticallyEqual.areEqual((J)fa.getTarget(), (J)nullChecked)) {
                    couldModifyValue.set(true);
                }
                return fa;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean couldModifyValue) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)couldModifyValue);
                if (SemanticallyEqual.areEqual((J)mi, (J)nullChecked) || mi.getSelect() != null && SemanticallyEqual.areEqual((J)mi.getSelect(), (J)nullChecked)) {
                    couldModifyValue.set(true);
                }
                return mi;
            }
        }.reduce((Tree)expression, (Object)new AtomicBoolean(false))).get();
    }

    @ConstructorProperties(value={"cursor", "nullCheckedParameter"})
    @Generated
    public NullCheck(Cursor cursor, Expression nullCheckedParameter) {
        this.cursor = cursor;
        this.nullCheckedParameter = nullCheckedParameter;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public Expression getNullCheckedParameter() {
        return this.nullCheckedParameter;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NullCheck)) {
            return false;
        }
        NullCheck other = (NullCheck)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        Expression this$nullCheckedParameter = this.getNullCheckedParameter();
        Expression other$nullCheckedParameter = other.getNullCheckedParameter();
        return !(this$nullCheckedParameter == null ? other$nullCheckedParameter != null : !this$nullCheckedParameter.equals(other$nullCheckedParameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        Expression $nullCheckedParameter = this.getNullCheckedParameter();
        result = result * 59 + ($nullCheckedParameter == null ? 43 : $nullCheckedParameter.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "NullCheck(cursor=" + this.getCursor() + ", nullCheckedParameter=" + this.getNullCheckedParameter() + ")";
    }

    public static class Matcher
    extends SimpleTraitMatcher<NullCheck> {
        public static Matcher nullCheck() {
            return new Matcher();
        }

        protected @Nullable NullCheck test(Cursor cursor) {
            J.Binary binary;
            J.If if_;
            if (cursor.getValue() instanceof J.If && (if_ = (J.If)cursor.getValue()).getIfCondition().getTree() instanceof J.Binary && (binary = (J.Binary)if_.getIfCondition().getTree()).getOperator() == J.Binary.Type.Equal) {
                if (J.Literal.isLiteralValue((Expression)binary.getLeft(), null)) {
                    return new NullCheck(cursor, binary.getRight());
                }
                if (J.Literal.isLiteralValue((Expression)binary.getRight(), null)) {
                    return new NullCheck(cursor, binary.getLeft());
                }
            }
            return null;
        }
    }
}

