/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class NoGuavaRefasterRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster style Guava to Java migration recipes";
    }

    public String getDescription() {
        return "Recipes that migrate from Guava to Java, using Refaster style templates for cases beyond what declarative recipes can cover.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new PreconditionsCheckNotNullToObjectsRequireNonNullRecipe(), new PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullRecipe(), new PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullMessageTypeObjectRecipe()});
    }

    @NullMarked
    public static class PreconditionsCheckNotNullToObjectsRequireNonNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`Preconditions.checkNotNull` to `Objects.requireNonNull`";
        }

        public String getDescription() {
            return "Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(java.lang.Object)})").bindType("java.lang.Object").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(java.lang.Object)})").bindType("java.lang.Object").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Preconditions", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`Preconditions.checkNotNull` with `String` message to `Objects.requireNonNull`";
        }

        public String getDescription() {
            return "Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)})").bindType("java.lang.Object").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)})").bindType("java.lang.Object").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Preconditions", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullMessageTypeObjectRecipe
    extends Recipe {
        public String getDisplayName() {
            return "`Preconditions.checkNotNull` with `Object` message to `Objects.requireNonNull` with `String.valueOf`";
        }

        public String getDescription() {
            return "Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.Object)})").bindType("java.lang.Object").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(java.lang.Object)}, String.valueOf(#{message:any(java.lang.Object)}))").bindType("java.lang.Object").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Preconditions", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

